/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.SelectObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class BooleanRadio
extends AbstractValueEditor {
    protected Button trueRadio;
    protected Button falseRadio;
    private ControlDecoration controlDecoration;

    public BooleanRadio(Composite parent, int style) {
        this(parent, style, null);
    }

    public BooleanRadio(Composite parent, int style, String label) {
        super(parent, label);
        ((GridLayout)this.getLayout()).numColumns = 3;
        this.trueRadio = factory.createButton((Composite)this, "true", style | 0x10);
        this.trueRadio.setBackground(this.getBackground());
        this.falseRadio = factory.createButton((Composite)this, "false", style | 0x10);
        this.falseRadio.setBackground(this.getBackground());
        this.setWidgetObservable(this.getObservable(), true);
        this.controlDecoration = new ControlDecoration((Control)this.trueRadio, 16512);
        GridData gridData = new GridData();
        this.trueRadio.setLayoutData((Object)gridData);
        this.falseRadio.setLayoutData((Object)gridData);
        gridData.horizontalIndent = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
    }

    private IObservableValue getObservable() {
        ISWTObservableValue trueObservable = WidgetProperties.selection().observe((Widget)this.trueRadio);
        ISWTObservableValue falseObservable = WidgetProperties.selection().observe((Widget)this.falseRadio);
        SelectObservableValue observable = new SelectObservableValue();
        observable.addOption((Object)true, (IObservableValue)trueObservable);
        observable.addOption((Object)false, (IObservableValue)falseObservable);
        return observable;
    }

    @Override
    public Object getEditableType() {
        return Boolean.class;
    }

    @Override
    public Boolean getValue() {
        return this.trueRadio.getSelection();
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.trueRadio.setEnabled(!readOnly);
        this.falseRadio.setEnabled(!readOnly);
    }

    @Override
    public boolean isReadOnly() {
        return !this.trueRadio.isEnabled() || !this.falseRadio.isEnabled();
    }

    public void setToolTipText(String text) {
        this.trueRadio.setToolTipText(text);
        this.falseRadio.setToolTipText(text);
        super.setLabelToolTipText(text);
    }
}

