/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.ui.TeamImages;
import org.eclipse.ui.PlatformUI;

public class KeyboardInteractiveDialog
extends TrayDialog {
    private Text[] texts;
    protected Image keyLockImage;
    protected Button allowCachingButton;
    protected Text usernameField;
    protected String userName;
    protected String domain;
    protected String destination;
    protected String name;
    protected String instruction;
    protected String lang;
    protected String[] prompt;
    protected boolean[] echo;
    private String message;
    private String[] result;
    protected boolean allowCaching = false;
    private boolean cachingDialog = false;
    private boolean isPasswordAuth = false;

    public KeyboardInteractiveDialog(Shell parentShell, String location, String destination, String name, String userName, String instruction, String[] prompt, boolean[] echo, boolean cachingDialog) {
        super(parentShell);
        this.domain = location;
        this.destination = destination;
        this.name = name;
        this.userName = userName;
        this.instruction = instruction;
        this.prompt = prompt;
        this.echo = echo;
        this.cachingDialog = cachingDialog;
        this.message = NLS.bind((String)CVSUIMessages.KeyboradInteractiveDialog_message, (Object[])new String[]{String.valueOf(destination) + (name != null && name.length() > 0 ? ": " + name : "")});
        if (KeyboardInteractiveDialog.isPasswordAuth(prompt)) {
            this.isPasswordAuth = true;
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.isPasswordAuth) {
            newShell.setText(CVSUIMessages.UserValidationDialog_required);
        } else {
            newShell.setText(this.message);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.team.cvs.ui.keyboard_interactive_dialog_context");
    }

    public void create() {
        super.create();
        if (this.isPasswordAuth && this.usernameField != null && this.userName != null) {
            this.usernameField.setText(this.userName);
            this.usernameField.setEditable(false);
        }
        if (this.texts.length > 0) {
            this.texts[0].setFocus();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(768));
        Composite imageComposite = new Composite(top, 0);
        layout = new GridLayout();
        imageComposite.setLayout((Layout)layout);
        imageComposite.setLayoutData((Object)new GridData(1040));
        Composite main = new Composite(top, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(768));
        Label imageLabel = new Label(imageComposite, 0);
        this.keyLockImage = TeamImages.getImageDescriptor((String)"wizban/keylock.gif").createImage();
        imageLabel.setImage(this.keyLockImage);
        GridData data = new GridData(768);
        imageLabel.setLayoutData((Object)data);
        if (this.message != null) {
            Label messageLabel = new Label(main, 64);
            messageLabel.setText(this.message);
            data = new GridData(768);
            data.horizontalSpan = 3;
            data.widthHint = 300;
            messageLabel.setLayoutData((Object)data);
        }
        if (this.domain != null) {
            Label d = new Label(main, 64);
            d.setText(CVSUIMessages.UserValidationDialog_5);
            data = new GridData();
            d.setLayoutData((Object)data);
            Label label = new Label(main, 64);
            label.setText(NLS.bind((String)CVSUIMessages.UserValidationDialog_labelUser, (Object[])new String[]{this.domain}));
            data = new GridData(768);
            data.horizontalSpan = 2;
            data.widthHint = 300;
            label.setLayoutData((Object)data);
        }
        if (this.instruction != null && this.instruction.length() > 0) {
            Label label = new Label(main, 64);
            label.setText(this.instruction);
            data = new GridData(768);
            data.horizontalSpan = 3;
            data.widthHint = 300;
            label.setLayoutData((Object)data);
        }
        if (this.isPasswordAuth) {
            this.createUsernameFields(main);
        }
        this.createPasswordFields(main);
        if (this.cachingDialog && this.isPasswordAuth) {
            this.allowCachingButton = new Button(main, 32);
            this.allowCachingButton.setText(CVSUIMessages.UserValidationDialog_6);
            data = new GridData(768);
            data.horizontalSpan = 3;
            this.allowCachingButton.setLayoutData((Object)data);
            this.allowCachingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    KeyboardInteractiveDialog.this.allowCaching = KeyboardInteractiveDialog.this.allowCachingButton.getSelection();
                }
            });
        }
        Dialog.applyDialogFont((Control)parent);
        return main;
    }

    protected void createUsernameFields(Composite parent) {
        new Label(parent, 0).setText(CVSUIMessages.UserValidationDialog_user);
        this.usernameField = new Text(parent, 2048);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        this.usernameField.setLayoutData((Object)data);
    }

    protected void createPasswordFields(Composite parent) {
        this.texts = new Text[this.prompt.length];
        int i = 0;
        while (i < this.prompt.length) {
            new Label(parent, 0).setText(this.prompt[i]);
            this.texts[i] = new Text(parent, 0x400800);
            GridData data = new GridData(768);
            data.horizontalSpan = 2;
            data.widthHint = this.convertHorizontalDLUsToPixels(200);
            this.texts[i].setLayoutData((Object)data);
            if (!this.echo[i]) {
                this.texts[i].setEchoChar('*');
            }
            ++i;
        }
    }

    public String[] getResult() {
        return this.result;
    }

    public boolean getAllowCaching() {
        return this.allowCaching;
    }

    protected void okPressed() {
        this.result = new String[this.prompt.length];
        int i = 0;
        while (i < this.texts.length) {
            this.result[i] = this.texts[i].getText();
            ++i;
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        this.result = null;
        super.cancelPressed();
    }

    public boolean close() {
        if (this.keyLockImage != null) {
            this.keyLockImage.dispose();
        }
        return super.close();
    }

    static boolean isPasswordAuth(String[] prompt) {
        return prompt != null && prompt.length == 1 && prompt[0].trim().equalsIgnoreCase("password:");
    }
}

