/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.efs;

import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.net4j.util.WrappedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfiniteProgress
extends ProgressMonitorWrapper {
    private static final Object NO_RESULT = new Object();
    private int totalWork;
    private int currentIncrement;
    private int halfWay;
    private int nextProgress;
    private int worked;

    protected InfiniteProgress(IProgressMonitor monitor) {
        super(monitor);
        this.nextProgress = this.currentIncrement = 4;
        this.worked = 0;
    }

    public void beginTask(String name, int work) {
        super.beginTask(name, work);
        this.totalWork = work;
        this.halfWay = this.totalWork / 2;
    }

    public void worked(int work) {
        if (--this.nextProgress <= 0) {
            super.worked(1);
            ++this.worked;
            if (this.worked >= this.halfWay) {
                this.currentIncrement *= 2;
                this.halfWay += (this.totalWork - this.halfWay) / 2;
            }
            this.nextProgress = this.currentIncrement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static <T> T call(final String label, final Callable<T> callable) {
        final Object[] result = new Object[]{NO_RESULT};
        final IProgressMonitor[] jobMonitor = new IProgressMonitor[1];
        Job job = new Job(label){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                jobMonitor[0] = new InfiniteProgress(monitor);
                jobMonitor[0].beginTask(label, 10);
                try {
                    result[0] = callable.call();
                    Object[] objectArray = result;
                    synchronized (result) {
                        result.notifyAll();
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                }
                catch (Throwable t) {
                    result[0] = t;
                    if (jobMonitor[0].isCanceled()) {
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    Status status = new Status(4, "org.eclipse.emf.cdo.efs", t.getLocalizedMessage(), t);
                    return status;
                }
                finally {
                    monitor = jobMonitor[0];
                    jobMonitor[0] = null;
                    monitor.done();
                }
            }
        };
        job.schedule();
        while (result[0] == NO_RESULT) {
            Object[] objectArray = result;
            // MONITORENTER : result
            if (jobMonitor[0] != null) {
                if (jobMonitor[0].isCanceled()) {
                    job.cancel();
                    throw new OperationCanceledException();
                }
                jobMonitor[0].worked(1);
            }
            try {
                System.out.println("wait...");
                result.wait(100L);
            }
            catch (InterruptedException ex) {
                job.cancel();
                throw new OperationCanceledException();
            }
        }
        if (result[0] instanceof Error) {
            throw (Error)result[0];
        }
        if (!(result[0] instanceof Exception)) return (T)result[0];
        throw WrappedException.wrap((Exception)((Exception)result[0]));
    }
}

