/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.contracts.transformations.dialogs;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.polarsys.chess.core.Activator;

public class RefinementResultDialog
extends Dialog {
    private Shell shell;
    private String resultText;

    public RefinementResultDialog(Shell parentShell, String result) {
        super(parentShell);
        this.shell = parentShell;
        this.resultText = result;
        Image image = null;
        URL url = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("/resources/CHESSicon.gif"), null);
        try {
            url = FileLocator.toFileURL((URL)url);
            image = Activator.getImageDescriptor((String)url.toString()).createImage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Dialog.setDefaultImage(image);
    }

    protected Control createDialogArea(Composite parent) {
        StyleRange style;
        Display display = this.shell.getDisplay();
        Color green = display.getSystemColor(5);
        Color red = display.getSystemColor(3);
        Color blue = display.getSystemColor(9);
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        StyledText text = new StyledText(parent, 2818);
        text.setText(this.resultText);
        String match = "[OK]";
        int i = -1;
        while ((i = this.resultText.indexOf(match, i + 1)) != -1) {
            style = new StyleRange();
            style.start = i;
            style.length = 4;
            style.fontStyle = 1;
            style.foreground = green;
            text.setStyleRange(style);
        }
        match = "[BOUND OK]";
        i = -1;
        while ((i = this.resultText.indexOf(match, i + 1)) != -1) {
            style = new StyleRange();
            style.start = i;
            style.length = 10;
            style.fontStyle = 1;
            style.foreground = blue;
            text.setStyleRange(style);
        }
        match = "[NOT OK]";
        i = -1;
        while ((i = this.resultText.indexOf(match, i + 1)) != -1) {
            style = new StyleRange();
            style.start = i;
            style.length = 8;
            style.fontStyle = 1;
            style.foreground = red;
            text.setStyleRange(style);
        }
        text.setEditable(false);
        text.setLayoutData((Object)data);
        return super.createDialogArea(parent);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Check Contract Refinement Report");
        shell.setSize(500, 350);
        Monitor primary = shell.getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        shell.setLocation(x, y);
    }

    protected boolean isResizable() {
        return true;
    }
}

