/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.marte.textedit.constraintwithvsl.xtext.ui.contributions;

import com.google.inject.Injector;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.extensionpoints.editors.configuration.ICustomDirectEditorConfiguration;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.marte.textedit.constraintwithvsl.xtext.constraintWithVSLl.ConstraintRule;
import org.eclipse.papyrus.marte.textedit.constraintwithvsl.xtext.constraintWithVSLl.ConstraintSpecification;
import org.eclipse.papyrus.marte.textedit.constraintwithvsl.xtext.ui.internal.ConstraintWithVSLlActivator;
import org.eclipse.papyrus.marte.vsl.extensions.VSLSerializationUtil;
import org.eclipse.papyrus.marte.vsl.vSL.Expression;
import org.eclipse.papyrus.uml.xtext.integration.DefaultXtextDirectEditorConfiguration;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;

public class ConstraintWithVSLPopupEditorConfiguration
extends DefaultXtextDirectEditorConfiguration
implements ICustomDirectEditorConfiguration {
    public String getTextToEdit(Object editedObject) {
        if (editedObject instanceof Constraint) {
            Constraint theConstraint = (Constraint)editedObject;
            if (theConstraint.getSpecification() != null && theConstraint.getSpecification() instanceof OpaqueExpression) {
                OpaqueExpression spec = (OpaqueExpression)theConstraint.getSpecification();
                int indexOfVSLExpression = -1;
                int i = 0;
                for (String language : spec.getLanguages()) {
                    if (language.equals("VSL")) {
                        indexOfVSLExpression = i;
                    }
                    ++i;
                }
                return indexOfVSLExpression != -1 ? (String)spec.getBodies().get(indexOfVSLExpression) : "";
            }
            return "";
        }
        return "Not a Constraint";
    }

    public Injector getInjector() {
        return ConstraintWithVSLlActivator.getInstance().getInjector("org.eclipse.papyrus.marte.textedit.constraintwithvsl.xtext.ConstraintWithVSLl");
    }

    protected ICommand getParseCommand(EObject umlObject, EObject xtextObject) {
        ConstraintSpecification newSpecification = null;
        ConstraintRule rule = (ConstraintRule)xtextObject;
        newSpecification = rule.getSpecification();
        String newBody = null;
        if (newSpecification != null) {
            newBody = VSLSerializationUtil.printExpression((Expression)newSpecification.getExpression());
        }
        if (!(umlObject instanceof Constraint)) {
            return UnexecutableCommand.INSTANCE;
        }
        if (newBody == null) {
            return UnexecutableCommand.INSTANCE;
        }
        Constraint constraint = (Constraint)umlObject;
        UpdateConstraintWithVSLCommand updateCommand = new UpdateConstraintWithVSLCommand(constraint, newBody);
        return updateCommand;
    }

    protected class UpdateConstraintWithVSLCommand
    extends AbstractTransactionalCommand {
        private Constraint theConstraint;
        private String newBody;

        protected CommandResult doExecuteWithResult(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
            this.theConstraint.setSpecification(null);
            OpaqueExpression opaqueExp = UMLFactory.eINSTANCE.createOpaqueExpression();
            opaqueExp.getLanguages().add((Object)"VSL");
            opaqueExp.getBodies().add((Object)this.newBody);
            this.theConstraint.setSpecification((ValueSpecification)opaqueExp);
            return CommandResult.newOKCommandResult((Object)this.theConstraint);
        }

        public UpdateConstraintWithVSLCommand(Constraint constraint, String newBody) {
            super((TransactionalEditingDomain)EMFHelper.resolveEditingDomain((EObject)constraint), "Constraint Update", UpdateConstraintWithVSLCommand.getWorkspaceFiles((EObject)constraint));
            this.theConstraint = constraint;
            this.newBody = newBody;
        }
    }
}

