/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.pages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.commands.CreationCommandDescriptor;
import org.eclipse.papyrus.commands.CreationCommandRegistry;
import org.eclipse.papyrus.commands.ICreationCommandRegistry;
import org.eclipse.papyrus.infra.viewpoints.configuration.Category;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrus.uml.diagram.wizards.Messages;
import org.eclipse.papyrus.uml.diagram.wizards.SettingsHelper;
import org.eclipse.papyrus.uml.diagram.wizards.kind.DiagramKindContentProvider;
import org.eclipse.papyrus.uml.diagram.wizards.kind.DiagramKindLabelProvider;
import org.eclipse.papyrus.uml.diagram.wizards.template.ModelTemplateDescription;
import org.eclipse.papyrus.uml.diagram.wizards.template.SelectModelTemplateComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectDiagramKindPage
extends WizardPage {
    public static final String PAGE_ID = "SelectDiagramKind";
    private Text nameText;
    private CheckboxTableViewer diagramKindTableViewer;
    private SettingsHelper mySettingsHelper;
    private SelectModelTemplateComposite selectTemplateComposite;
    private Button rememberCurrentSelection;
    private final CategoryProvider myCategoryProvider;
    private final boolean allowTemplates;
    private final ICreationCommandRegistry myCreationCommandRegistry;
    public static final ICreationCommandRegistry DEFAULT_CREATION_COMMAND_REGISTRY = CreationCommandRegistry.getInstance((String)"org.eclipse.papyrus.infra.core");

    public SelectDiagramKindPage(CategoryProvider categoryProvider) {
        this(true, categoryProvider, DEFAULT_CREATION_COMMAND_REGISTRY);
    }

    public SelectDiagramKindPage(boolean allowTemplates, CategoryProvider categoryProvider, ICreationCommandRegistry creationCommandRegistry) {
        super(PAGE_ID);
        this.setTitle(Messages.SelectDiagramKindPage_page_title);
        this.setDescription(Messages.SelectDiagramKindPage_page_desc);
        this.allowTemplates = allowTemplates;
        this.myCategoryProvider = categoryProvider;
        this.myCreationCommandRegistry = creationCommandRegistry;
    }

    public void createControl(Composite parent) {
        Composite plate = new Composite(parent, 0);
        plate.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 10;
        plate.setLayout((Layout)gridLayout);
        this.setControl((Control)plate);
        String[] categories = this.getDiagramCategories();
        this.createNameForm(plate);
        this.createDiagramKindForm(plate);
        this.diagramKindTableViewer.setInput((Object)categories);
        this.createModelTemplateComposite(plate);
        this.createRememberCurrentSelectionForm(plate);
        this.fillInTables(categories);
    }

    public void setWizard(IWizard newWizard) {
        super.setWizard(newWizard);
        this.setSettingsHelper(new SettingsHelper(this.getDialogSettings()));
    }

    protected void setSettingsHelper(SettingsHelper helper) {
        this.mySettingsHelper = helper;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fillInTables(this.getDiagramCategories());
            this.validatePage();
            if (!this.allowTemplates) {
                this.selectTemplateComposite.disable();
            }
        }
    }

    private void fillInTables(String[] categories) {
        if (categories == null || categories.length == 0) {
            return;
        }
        this.diagramKindTableViewer.setInput((Object)categories);
        this.selectTemplateComposite.setInput(categories);
        this.selectDefaultDiagramKinds(categories);
        this.selectDefaultDiagramTemplates(categories);
    }

    public String getTemplatePath() {
        return this.selectTemplateComposite.getTemplatePath();
    }

    public String getNotationTemplatePath() {
        return this.selectTemplateComposite.getNotationTemplatePath();
    }

    public String getDiTemplatePath() {
        return this.selectTemplateComposite.getDiTemplatePath();
    }

    public String getTemplatePluginId() {
        return this.selectTemplateComposite.getTemplatePluginId();
    }

    private String[] getDiagramCategories() {
        return this.myCategoryProvider.getCurrentCategories();
    }

    public String getDiagramName() {
        return this.nameText.getText();
    }

    public boolean templatesEnabled() {
        return this.allowTemplates;
    }

    public List<ViewPrototype> getSelectedPrototypes(String categoryId) {
        ViewPrototype[] selected = this.getSelectedPrototypes();
        ArrayList<ViewPrototype> commands = new ArrayList<ViewPrototype>();
        int i = 0;
        while (i < selected.length) {
            for (Category category : selected[i].getCategories()) {
                if (!category.getName().equals(categoryId)) continue;
                commands.add(selected[i]);
                break;
            }
            ++i;
        }
        return commands;
    }

    private void createModelTemplateComposite(Composite composite) {
        Group group = SelectDiagramKindPage.createGroup(composite, Messages.SelectDiagramKindPage_load_template_group);
        this.selectTemplateComposite = new SelectModelTemplateComposite((Composite)group);
    }

    private void createDiagramKindForm(Composite composite) {
        Group group = SelectDiagramKindPage.createGroup(composite, Messages.SelectDiagramKindPage_select_kind_group);
        GridData data = new GridData(4, 4, true, true);
        group.setData((Object)data);
        Table diagramKindTable = new Table((Composite)group, 262176);
        diagramKindTable.setFont(group.getFont());
        diagramKindTable.setBackground(group.getBackground());
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        diagramKindTable.setLayout((Layout)layout);
        GridData data2 = new GridData(4, 4, true, true);
        diagramKindTable.setLayoutData((Object)data2);
        diagramKindTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32) {
                    SelectDiagramKindPage.this.validatePage();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.diagramKindTableViewer = new CheckboxTableViewer(diagramKindTable);
        this.diagramKindTableViewer.setContentProvider((IContentProvider)new DiagramKindContentProvider());
        this.diagramKindTableViewer.setLabelProvider(this.createDiagramKindLabelProvider());
    }

    protected IBaseLabelProvider createDiagramKindLabelProvider() {
        return new DiagramKindLabelProvider();
    }

    private static Group createGroup(Composite parent, String name) {
        Group group = new Group(parent, 0);
        group.setText(name);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        group.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        group.setLayoutData((Object)data);
        return group;
    }

    private void createNameForm(Composite composite) {
        Group group = SelectDiagramKindPage.createGroup(composite, Messages.SelectDiagramKindPage_diagram_name_group);
        this.nameText = new Text((Composite)group, 2048);
        GridData data = new GridData(768);
        this.nameText.setLayoutData((Object)data);
        this.nameText.setText(Messages.SelectDiagramKindPage_default_diagram_name);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectDiagramKindPage.this.validatePage();
            }
        });
    }

    private void createRememberCurrentSelectionForm(Composite composite) {
        Composite plate = new Composite(composite, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        plate.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        plate.setLayoutData((Object)data);
        this.rememberCurrentSelection = new Button(plate, 32);
        this.rememberCurrentSelection.setText(Messages.SelectDiagramKindPage_remember_current_selection_text);
        this.rememberCurrentSelection.setToolTipText(Messages.SelectDiagramKindPage_remember_current_selection_tooltip);
        this.rememberCurrentSelection.setSelection(this.mySettingsHelper.rememberCurrentSelection(this.getDialogSettings()));
    }

    private boolean validatePage() {
        if (this.getDiagramName() == null || this.getDiagramName().length() == 0) {
            this.updateStatus(Messages.SelectDiagramKindPage_diagram_name_is_empty);
            return false;
        }
        this.updateStatus(null);
        return true;
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public boolean isRememberCurrentSelection() {
        return this.rememberCurrentSelection.getSelection();
    }

    public String[] getSelectedDiagramKinds(String categoryId) {
        return new String[0];
    }

    protected ViewPrototype[] getSelectedPrototypes() {
        Object[] checked = this.diagramKindTableViewer.getCheckedElements();
        ViewPrototype[] result = Arrays.asList(checked).toArray(new ViewPrototype[checked.length]);
        return result;
    }

    private void selectDefaultDiagramKinds(String[] categories) {
        HashSet<String> kinds = new HashSet<String>();
        String[] stringArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            String category = stringArray[n2];
            kinds.addAll(this.mySettingsHelper.getDefaultDiagramKinds(category));
            ++n2;
        }
        Object[] elementsToCheck = this.findCreationCommandDescriptorsFor(kinds);
        this.diagramKindTableViewer.setCheckedElements(elementsToCheck);
    }

    protected CreationCommandDescriptor[] findCreationCommandDescriptorsFor(Collection<String> kinds) {
        ArrayList<CreationCommandDescriptor> result = new ArrayList<CreationCommandDescriptor>();
        Collection availableDescriptors = this.getCreationCommandRegistry().getCommandDescriptors();
        for (CreationCommandDescriptor desc : availableDescriptors) {
            if (!kinds.contains(desc.getCommandId())) continue;
            result.add(desc);
        }
        return result.toArray(new CreationCommandDescriptor[result.size()]);
    }

    private void selectDefaultDiagramTemplates(String[] categories) {
        ArrayList<String> defaultTemplates = new ArrayList<String>();
        ArrayList<Object> availableTemplates = new ArrayList<Object>();
        String[] stringArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            defaultTemplates.addAll(this.mySettingsHelper.getDefaultTemplates(string));
            ++n2;
        }
        availableTemplates.addAll(Arrays.asList(this.selectTemplateComposite.getContentProvider().getElements(categories)));
        for (Object e : availableTemplates) {
            ModelTemplateDescription desc = (ModelTemplateDescription)e;
            if (!defaultTemplates.contains(desc.getUml_path())) continue;
            this.selectTemplateComposite.selectElement(desc);
            return;
        }
    }

    protected final ICreationCommandRegistry getCreationCommandRegistry() {
        return this.myCreationCommandRegistry;
    }

    public static interface CategoryProvider {
        public String[] getCurrentCategories();
    }
}

