/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.extensions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.incquery.runtime.api.IModelConnectorTypeEnum;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.viewers.runtime.ViewersRuntimePlugin;
import org.eclipse.incquery.viewers.runtime.extensions.IncQueryViewersPartSupport;
import org.eclipse.incquery.viewers.runtime.extensions.ViewersComponentConfiguration;
import org.eclipse.incquery.viewers.runtime.model.ViewerState;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public abstract class IncQueryViewersViewSupport
extends IncQueryViewersPartSupport {
    protected IModelConnectorTypeEnum connectorType = IModelConnectorTypeEnum.RESOURCESET;
    protected ViewerState state;
    protected Notifier modelSource;
    private Composite parent;
    private Composite cover;
    private Control contents;
    private StackLayout layout;

    public IncQueryViewersViewSupport(IViewPart _owner, ViewersComponentConfiguration _config, IModelConnectorTypeEnum _scope) {
        super((IWorkbenchPart)_owner, _config);
        this.connectorType = _scope;
    }

    protected IViewPart getOwner() {
        return (IViewPart)this.owner;
    }

    @Override
    public void dispose() {
        this.unbindModel();
        super.dispose();
    }

    @Override
    protected void filteredSelectionChanged(List<Notifier> eObjects) {
        Notifier target = this.extractModelSource(eObjects);
        if (target != null && !target.equals(this.modelSource)) {
            this.unsetModelSource();
            this.setModelSource(target);
        }
    }

    private Notifier extractModelSource(List<Notifier> notifiers) {
        switch (this.connectorType) {
            default: {
                Iterator<Notifier> iterator = notifiers.iterator();
                if (!iterator.hasNext()) break;
                Notifier n = iterator.next();
                if (n instanceof ResourceSet) {
                    return n;
                }
                if (n instanceof Resource) {
                    return ((Resource)n).getResourceSet();
                }
                EObject eO = (EObject)n;
                return eO.eResource().getResourceSet();
            }
            case RESOURCE: 
        }
        for (Notifier n : notifiers) {
            if (n instanceof ResourceSet) continue;
            if (n instanceof Resource) {
                return (Resource)n;
            }
            EObject eO = (EObject)n;
            return eO.eResource();
        }
        return null;
    }

    private void setModelSource(Notifier p) {
        this.modelSource = p;
        this.bindModel();
        this.showView();
    }

    private void unsetModelSource() {
        this.hideView();
        this.unbindModel();
        this.modelSource = null;
    }

    protected IncQueryEngine getEngine() {
        Assert.isNotNull((Object)this.modelSource);
        try {
            return IncQueryEngine.on((Notifier)this.modelSource);
        }
        catch (IncQueryException e) {
            ViewersRuntimePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.incquery.viewers.runtime", e.getLocalizedMessage(), (Throwable)e));
            return null;
        }
    }

    public void createPartControl(Composite _parent, Control _contents) {
        this.parent = _parent;
        this.layout = new StackLayout();
        this.parent.setLayout((Layout)this.layout);
        this.contents = _contents;
        this.cover = new Composite(this.parent, 16);
        this.layout.topControl = this.cover;
        this.init();
    }

    private void showView() {
        this.layout.topControl = this.contents;
        this.parent.layout();
    }

    private void hideView() {
        this.layout.topControl = this.cover;
        this.parent.layout();
    }

    protected abstract void bindModel();

    protected abstract void unbindModel();
}

