/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.papyrus.MARTE.MARTE_Foundations.Alloc.Assign;
import org.eclipse.papyrus.MARTE.MARTE_Foundations.GRM.Resource;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EObjectTreeElement;
import org.eclipse.papyrus.sysml.blocks.Block;
import org.eclipse.papyrus.sysml.portandflows.FlowPort;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.polarsys.chess.chessmlprofile.ComponentModel.ComponentType;
import org.polarsys.chess.chessmlprofile.Core.CHESS;
import org.polarsys.chess.chessmlprofile.Core.CHESSViews.DeploymentView;
import org.polarsys.chess.chessmlprofile.Core.CHGaResourcePlatform;
import org.polarsys.chess.chessmlprofile.Dependability.DependableComponent.Propagation;
import org.polarsys.chess.chessmlprofile.Predictability.RTComponentModel.CHRtPortSlot;
import org.polarsys.chess.chessmlprofile.Predictability.RTComponentModel.CHRtSpecification;
import org.polarsys.chess.commands.AssignCopy;
import org.polarsys.chess.core.notifications.ResourceNotification;
import org.polarsys.chess.core.profiles.CHESSProfileManager;
import org.polarsys.chess.core.util.uml.UMLUtils;
import org.polarsys.chess.core.views.DiagramStatus;
import org.polarsys.chess.core.views.ViewUtils;
import org.polarsys.chess.service.utils.CHESSEditorUtils;

public class BuildModelInstanceCommand
extends AbstractHandler
implements IHandler {
    private static final String MARTE_CSP = "MARTE::MARTE_DesignModel::GCM::ClientServerPort";
    private static final String MARTE_RESOURCE = "MARTE::MARTE_Foundations::GRM::Resource";
    private static final String MARTE_ASSIGN = "MARTE::MARTE_Foundations::Alloc::Assign";
    private static final String MARTE_MEMORYPARTITION = "MARTE::MARTE_DesignModel::SRM::SW_Concurrency::MemoryPartition";
    private static ArrayList<AssignCopy> acList;
    private static EList<Comment> assigns;
    private static ArrayList<InstanceSpecification> instancesList;
    private static ArrayList<Slot> slotList;
    private boolean ignoreErrors;
    private InstanceSpecification oldRootInstance = null;
    private Package oldInstancePackage = null;
    private Map<Property, InstanceSpecification> property2InstMap = new HashMap<Property, InstanceSpecification>();
    private CHGaResourcePlatform resPlatform = null;

    static {
        instancesList = new ArrayList();
        slotList = new ArrayList();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.ignoreErrors = false;
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        ISelectionService selectionService = window.getSelectionService();
        ISelection selectionX = selectionService.getSelection();
        if (!(selectionX instanceof ITreeSelection)) {
            ResourceNotification.showOk((String)"Please invoke the Build Instance command on a single selection on the ModelExplorer");
            return null;
        }
        ITreeSelection treesel = (ITreeSelection)selectionX;
        if (treesel.getPaths().length == 0 || treesel.getPaths().length > 1) {
            ResourceNotification.showError((String)"Please invoke the Build Instance command on a single selection on the ModelExplorer");
            return null;
        }
        Object obj = treesel.getFirstElement();
        if (!(obj instanceof EObjectTreeElement)) {
            ResourceNotification.showError((String)"Please invoke the Build Instance command on a single selection on the ModelExplorer");
        }
        EObject eobj = ((EObjectTreeElement)obj).getEObject();
        Package view = ViewUtils.getView((EObject)eobj);
        view.getModel();
        Class umlClass = (Class)eobj;
        if (!(ViewUtils.isDesignView((Package)view, (String)"SystemView") || ViewUtils.isDesignView((Package)view, (String)"ComponentView") || ViewUtils.isDesignView((Package)view, (String)"DeploymentView"))) {
            ResourceNotification.showError((String)"Build Instance command can only be invoked on resources of the SystemView, ComponentView and DeploymentView");
            return null;
        }
        if (ViewUtils.isDesignView((Package)view, (String)"ComponentView") && UMLUtils.getStereotypeApplication((Element)umlClass, ComponentType.class) != null) {
            ResourceNotification.showError((String)"Build Instance command cannot be invoked on ComponentType");
            return null;
        }
        return this.buildInstance(umlClass);
    }

    public InstanceSpecification buildInstance(final Class umlClass) {
        DiagramStatus ds;
        block2: {
            PapyrusMultiDiagramEditor editor = CHESSEditorUtils.getCHESSEditor();
            ds = CHESSEditorUtils.getDiagramStatus((PapyrusMultiDiagramEditor)editor);
            final Package view = ViewUtils.getView((EObject)umlClass);
            final Model umlModel = view.getModel();
            this.oldInstancePackage = null;
            this.oldRootInstance = null;
            try {
                TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)umlClass);
                editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

                    protected void doExecute() {
                        ds.setUserAction(false);
                        BuildModelInstanceCommand.saveAssignAllocations(umlModel);
                        Package instPkg = null;
                        for (Element elem : umlClass.getOwner().getOwnedElements()) {
                            if (!(elem instanceof Package) || !((Package)elem).getName().equals(String.valueOf(umlClass.getName()) + "_instSpec")) continue;
                            instPkg = (Package)elem;
                        }
                        if (instPkg != null) {
                            EList elems = instPkg.getPackagedElements();
                            Package pkg = umlClass.getNearestPackage();
                            BuildModelInstanceCommand.this.oldInstancePackage = pkg.createNestedPackage(String.valueOf(umlClass.getName()) + "_oldinstSpec");
                            BasicEList tempElems = new BasicEList();
                            int size = elems.size();
                            int i = 0;
                            while (i < size) {
                                PackageableElement pe = (PackageableElement)elems.get(i);
                                if (pe.getName() != null && !pe.getName().contains(".")) {
                                    BuildModelInstanceCommand.this.oldRootInstance = (InstanceSpecification)pe;
                                }
                                tempElems.add((Object)pe);
                                ++i;
                            }
                            BuildModelInstanceCommand.this.oldInstancePackage.getPackagedElements().addAll((Collection)tempElems);
                        } else {
                            Package pkg = umlClass.getNearestPackage();
                            instPkg = pkg.createNestedPackage(String.valueOf(umlClass.getName()) + "_instSpec");
                            UMLUtils.applyStereotype((Element)instPkg, (String)"CHESS::Core::CHGaResourcePlatform");
                        }
                        instancesList.clear();
                        slotList.clear();
                        BuildModelInstanceCommand.this.buildComponentInstance(instPkg, umlClass, null, null, BuildModelInstanceCommand.this.oldRootInstance);
                        if (!ViewUtils.isDesignView((Package)view, (String)"SystemView")) {
                            BuildModelInstanceCommand.regenerateAssignAllocations(umlModel);
                        }
                        if (BuildModelInstanceCommand.this.oldInstancePackage != null) {
                            BuildModelInstanceCommand.this.oldInstancePackage.destroy();
                        }
                        boolean compView = ViewUtils.isDesignView((Package)view, (String)"ComponentView");
                        String msg = "Instances have been successfully generated under the  " + instPkg.getName() + " Package.";
                        if (compView) {
                            msg = String.valueOf(msg) + "\n Check the CHESS Instance View to navigate and edit extra functional properties for SW instances.";
                        }
                        ResourceNotification.showOk((String)msg);
                    }
                });
            }
            catch (Exception e) {
                if (this.ignoreErrors) break block2;
                ds.setUserAction(false);
                e.printStackTrace();
                ResourceNotification.showError((String)("Problems while executing BuildInstance command: " + e.getMessage()));
            }
        }
        ds.setUserAction(false);
        return null;
    }

    private InstanceSpecification buildComponentInstance(Package pkg, Class umlClass, InstanceSpecification parentInstance, Property theProp, InstanceSpecification oldInst) {
        List<Comment> commList = this.getAllCHRTSpec(umlClass, theProp);
        InstanceSpecification inst = UMLFactory.eINSTANCE.createInstanceSpecification();
        if (theProp != null) {
            String name = String.valueOf(parentInstance.getName()) + "." + theProp.getName();
            inst.setName(name);
        } else {
            inst.setName(umlClass.getName());
        }
        inst.getClassifiers().add((Object)umlClass);
        pkg.getPackagedElements().add((Object)inst);
        if (parentInstance != null) {
            UMLUtils.applyStereotype((Element)inst, (String)MARTE_RESOURCE);
            Resource res = (Resource)inst.getStereotypeApplication(inst.getAppliedStereotype(MARTE_RESOURCE));
            this.resPlatform.getResources().add((Object)res);
        } else {
            Stereotype stereo = UMLUtils.applyStereotype((Element)inst, (String)"CHESS::Core::CHGaResourcePlatform");
            this.resPlatform = (CHGaResourcePlatform)inst.getStereotypeApplication(stereo);
        }
        if (theProp != null) {
            BuildModelInstanceCommand.mapStereotypesFromPropertyToInstance(theProp, inst, oldInst);
        }
        for (Property subProp : umlClass.getAttributes()) {
            CHRtPortSlot oldchrtportSlot;
            Stereotype oldstereo;
            Slot oldSlot;
            if (subProp.getType() instanceof Class) {
                Class subCompImpl = (Class)subProp.getType();
                if (!(subCompImpl instanceof Component) && UMLUtils.getStereotypeApplication((Element)subCompImpl, Block.class) == null) continue;
                InstanceSpecification oldsubInst = this.getCorrespondingOldChildInstance(subProp, oldInst);
                InstanceSpecification subInst = this.buildComponentInstance(pkg, subCompImpl, inst, subProp, oldsubInst);
                Slot slot = UMLFactory.eINSTANCE.createSlot();
                slot.setDefiningFeature((StructuralFeature)subProp);
                inst.getSlots().add((Object)slot);
                InstanceValue instValue = (InstanceValue)slot.createValue(subProp.getName(), null, UMLPackage.Literals.INSTANCE_VALUE);
                instValue.setInstance(subInst);
                continue;
            }
            if (subProp.getAppliedStereotype(MARTE_CSP) == null && UMLUtils.getStereotypeApplication((Element)subProp, FlowPort.class) == null) continue;
            Slot slot = UMLFactory.eINSTANCE.createSlot();
            slot.setDefiningFeature((StructuralFeature)subProp);
            inst.getSlots().add((Object)slot);
            slotList.add(slot);
            ArrayList<CHRtSpecification> tmpList = new ArrayList<CHRtSpecification>();
            for (Comment comm : commList) {
                if (comm.getAppliedStereotype("CHESS::Predictability::RTComponentModel::CHRtSpecification") == null || !comm.getAnnotatedElements().contains((Object)subProp)) continue;
                Stereotype chrtStereo = comm.getAppliedStereotype("CHESS::Predictability::RTComponentModel::CHRtSpecification");
                CHRtSpecification chrt = (CHRtSpecification)comm.getStereotypeApplication(chrtStereo);
                tmpList.add(chrt);
            }
            CHRtPortSlot chrtportSlot = null;
            if (tmpList.size() > 0) {
                Stereotype portSlotStereo = CHESSProfileManager.applyChRTPortSlotStereotype((Slot)slot);
                chrtportSlot = (CHRtPortSlot)slot.getStereotypeApplication(portSlotStereo);
                chrtportSlot.getCH_RtSpecification().addAll(tmpList);
            }
            if ((oldSlot = this.getCorrespondingOldChildSlot(subProp, oldInst)) == null || (oldstereo = oldSlot.getApplicableStereotype("CHESS::Predictability::RTComponentModel::CHRtPortSlot")) == null || (oldchrtportSlot = (CHRtPortSlot)oldSlot.getStereotypeApplication(oldstereo)) == null) continue;
            if (chrtportSlot == null) {
                Stereotype portSlotStereo = CHESSProfileManager.applyChRTPortSlotStereotype((Slot)slot);
                chrtportSlot = (CHRtPortSlot)slot.getStereotypeApplication(portSlotStereo);
            }
            chrtportSlot.getCH_RtSpecification().addAll((Collection)oldchrtportSlot.getCH_RtSpecification());
        }
        for (Connector conn : umlClass.getOwnedConnectors()) {
            this.buildConnectorInstance(pkg, conn, this.resPlatform, inst, this.property2InstMap);
        }
        instancesList.add(inst);
        if (theProp != null) {
            this.property2InstMap.put(theProp, inst);
        }
        ArrayList<CHRtSpecification> tmpList = new ArrayList<CHRtSpecification>();
        for (Comment comm : commList) {
            if (comm.getAppliedStereotype("CHESS::Predictability::RTComponentModel::CHRtSpecification") == null || !comm.getAnnotatedElements().contains((Object)umlClass)) continue;
            Stereotype chrtStereo = comm.getAppliedStereotype("CHESS::Predictability::RTComponentModel::CHRtSpecification");
            CHRtSpecification chrt = (CHRtSpecification)comm.getStereotypeApplication(chrtStereo);
            tmpList.add(chrt);
        }
        CHRtPortSlot chrtportSlot = null;
        if (tmpList.size() > 0) {
            Stereotype portSlotStereo = null;
            portSlotStereo = inst.getAppliedStereotype("CHESS::Predictability::RTComponentModel::CHRtPortSlot") != null ? inst.getAppliedStereotype("CHESS::Predictability::RTComponentModel::CHRtPortSlot") : CHESSProfileManager.applyChRTPortSlotStereotype((InstanceSpecification)inst);
            chrtportSlot = (CHRtPortSlot)inst.getStereotypeApplication(portSlotStereo);
            chrtportSlot.getCH_RtSpecification().addAll(tmpList);
        }
        return inst;
    }

    public static void mapStereotypesFromPropertyToInstance(Property property, InstanceSpecification instance, InstanceSpecification oldinstance) {
        Stereotype oldstereo;
        CHRtPortSlot oldchrtportSlot;
        Stereotype memPartition;
        Stereotype chHwComputingRes;
        Type type = property.getType();
        EObject stereo = property.getStereotypeApplication(CHESSProfileManager.getCH_HWBus((Element)property));
        Property elem = property;
        if (stereo == null) {
            stereo = type.getStereotypeApplication(CHESSProfileManager.getCH_HWBus((Element)type));
            elem = type;
        }
        if (stereo != null) {
            Stereotype chHwBus = CHESSProfileManager.applyCH_HwBusStereotype((Element)instance);
            instance.setValue(chHwBus, "transmMode", elem.getValue(chHwBus, "transmMode"));
            instance.setValue(chHwBus, "blockT", elem.getValue(chHwBus, "blockT"));
            instance.setValue(chHwBus, "packetT", elem.getValue(chHwBus, "packetT"));
            instance.setValue(chHwBus, "speedFactor", elem.getValue(chHwBus, "speedFactor"));
            instance.setValue(chHwBus, "resMult", elem.getValue(chHwBus, "resMult"));
        }
        stereo = property.getStereotypeApplication(CHESSProfileManager.getCH_HWComputingResource((Element)property));
        elem = property;
        if (stereo == null) {
            stereo = type.getStereotypeApplication(CHESSProfileManager.getCH_HWComputingResource((Element)type));
            elem = type;
        }
        if (stereo != null) {
            chHwComputingRes = CHESSProfileManager.applyCH_HwComputingResourceStereotype((Element)instance);
            instance.setValue(chHwComputingRes, "speedFactor", elem.getValue(chHwComputingRes, "speedFactor"));
            instance.setValue(chHwComputingRes, "resMult", elem.getValue(chHwComputingRes, "resMult"));
        }
        stereo = property.getStereotypeApplication(CHESSProfileManager.getCH_HWProcessor((Element)property));
        elem = property;
        if (stereo == null) {
            stereo = type.getStereotypeApplication(CHESSProfileManager.getCH_HWProcessor((Element)type));
            elem = type;
        }
        if (stereo != null) {
            chHwComputingRes = CHESSProfileManager.applyCH_HwProcessorStereotype((Element)instance);
            instance.setValue(chHwComputingRes, "speedFactor", elem.getValue(chHwComputingRes, "speedFactor"));
            instance.setValue(chHwComputingRes, "resMult", elem.getValue(chHwComputingRes, "resMult"));
        }
        if ((memPartition = property.getAppliedStereotype(MARTE_MEMORYPARTITION)) != null) {
            instance.applyStereotype(memPartition);
        }
        if (oldinstance != null && (oldchrtportSlot = (CHRtPortSlot)oldinstance.getStereotypeApplication(oldstereo = oldinstance.getApplicableStereotype("CHESS::Predictability::RTComponentModel::CHRtPortSlot"))) != null) {
            Stereotype newstereo = instance.getApplicableStereotype("CHESS::Predictability::RTComponentModel::CHRtPortSlot");
            CHRtPortSlot chrtportSlot = (CHRtPortSlot)instance.getStereotypeApplication(newstereo);
            if (chrtportSlot == null) {
                Stereotype portSlotStereo = CHESSProfileManager.applyChRTPortSlotStereotype((InstanceSpecification)instance);
                chrtportSlot = (CHRtPortSlot)instance.getStereotypeApplication(portSlotStereo);
            }
            chrtportSlot.getCH_RtSpecification().addAll((Collection)oldchrtportSlot.getCH_RtSpecification());
        }
    }

    private void buildConnectorInstance(Package pkg, Connector conn, CHGaResourcePlatform resPlatform, InstanceSpecification parentInstance, Map<Property, InstanceSpecification> property2InstMap) {
        InstanceSpecification connInst = UMLFactory.eINSTANCE.createInstanceSpecification();
        String name = String.valueOf(parentInstance.getName()) + "." + conn.getName();
        connInst.setName(name);
        pkg.getPackagedElements().add((Object)connInst);
        UMLUtils.applyStereotype((Element)connInst, (String)MARTE_RESOURCE);
        Resource res = (Resource)UMLUtils.getStereotypeApplication((Element)connInst, Resource.class);
        resPlatform.getResources().add((Object)res);
        Slot sourceSlot = connInst.createSlot();
        Slot targetSlot = connInst.createSlot();
        Port sourcePort = (Port)((ConnectorEnd)conn.getEnds().get(0)).getRole();
        sourceSlot.setDefiningFeature((StructuralFeature)sourcePort);
        InstanceValue value = (InstanceValue)sourceSlot.createValue("partWithPort", null, UMLPackage.Literals.INSTANCE_VALUE);
        Property sourceProperty = ((ConnectorEnd)conn.getEnds().get(0)).getPartWithPort();
        InstanceSpecification sourceInstance = sourceProperty == null ? parentInstance : property2InstMap.get(sourceProperty);
        value.setInstance(sourceInstance);
        targetSlot.setDefiningFeature((StructuralFeature)((ConnectorEnd)conn.getEnds().get(1)).getRole());
        value = (InstanceValue)targetSlot.createValue("partWithPort", null, UMLPackage.Literals.INSTANCE_VALUE);
        Property targetProperty = ((ConnectorEnd)conn.getEnds().get(1)).getPartWithPort();
        InstanceSpecification targetInstance = targetProperty == null ? parentInstance : property2InstMap.get(targetProperty);
        value.setInstance(targetInstance);
        Propagation origPropagation = (Propagation)UMLUtils.getStereotypeApplication((Element)conn, Propagation.class);
        if (origPropagation != null) {
            CHESSProfileManager.applyPropagationStereotype((InstanceSpecification)connInst);
            Propagation newPropagation = (Propagation)UMLUtils.getStereotypeApplication((Element)connInst, Propagation.class);
            newPropagation.setProb(origPropagation.getProb());
            newPropagation.setDelay(origPropagation.getDelay());
        }
    }

    private static void saveAssignAllocations(Model umlModel) {
        CHESS chess = (CHESS)UMLUtils.getStereotypeApplication((Element)umlModel, CHESS.class);
        DeploymentView deplView = chess.getDeploymentView();
        EList tmp = deplView.getAssignList();
        assigns = new BasicEList();
        int i = 0;
        while (i < tmp.size()) {
            if (((Comment)tmp.get(i)).getAppliedStereotype(MARTE_ASSIGN) != null) {
                assigns.add((Object)((Comment)tmp.get(i)));
            }
            ++i;
        }
        acList = AssignCopy.toAssignCopyList(assigns);
    }

    private static void regenerateAssignAllocations(Model umlModel) {
        int i = 0;
        while (i < acList.size()) {
            String slotName;
            Slot tmpSlot;
            Iterator<Slot> slotIt;
            InstanceSpecification tmpInst;
            Iterator<InstanceSpecification> instIt;
            Comment com = (Comment)assigns.get(i);
            Assign assign = (Assign)UMLUtils.getStereotypeApplication((Element)com, Assign.class);
            EList from = assign.getFrom();
            EList to = assign.getTo();
            AssignCopy ac = acList.get(i);
            for (String fromName : ac.getFrom()) {
                instIt = instancesList.iterator();
                InstanceSpecification isFrom = null;
                while (instIt.hasNext()) {
                    tmpInst = instIt.next();
                    if (!tmpInst.getName().equals(fromName)) continue;
                    isFrom = tmpInst;
                    break;
                }
                if (isFrom != null && !from.contains(isFrom)) {
                    from.add(isFrom);
                    continue;
                }
                slotIt = slotList.iterator();
                Slot slFrom = null;
                while (slotIt.hasNext()) {
                    tmpSlot = slotIt.next();
                    slotName = String.valueOf(tmpSlot.getOwningInstance().getQualifiedName()) + "::" + tmpSlot.getDefiningFeature().getName();
                    if (!slotName.equals(fromName)) continue;
                    slFrom = tmpSlot;
                    break;
                }
                if (slFrom == null || from.contains(slFrom)) continue;
                from.add(slFrom);
            }
            for (String toName : ac.getTo()) {
                instIt = instancesList.iterator();
                InstanceSpecification isTo = null;
                while (instIt.hasNext()) {
                    tmpInst = instIt.next();
                    if (!tmpInst.getName().equals(toName)) continue;
                    isTo = tmpInst;
                    break;
                }
                if (isTo != null && !to.contains(isTo)) {
                    to.add(isTo);
                    continue;
                }
                slotIt = slotList.iterator();
                Slot slTo = null;
                while (slotIt.hasNext()) {
                    tmpSlot = slotIt.next();
                    slotName = String.valueOf(tmpSlot.getOwningInstance().getQualifiedName()) + "::" + tmpSlot.getDefiningFeature().getName();
                    if (!slotName.equals(toName)) continue;
                    slTo = tmpSlot;
                    break;
                }
                if (slTo == null || to.contains(slTo)) continue;
                to.add(slTo);
            }
            ++i;
        }
    }

    private InstanceSpecification getCorrespondingOldChildInstance(Property prop, InstanceSpecification inst) {
        if (inst == null) {
            return null;
        }
        EList slots = inst.getSlots();
        for (Slot s : slots) {
            if (s.getDefiningFeature() == null || !s.getDefiningFeature().equals(prop)) continue;
            InstanceValue instvalue = (InstanceValue)s.getValues().get(0);
            return instvalue.getInstance();
        }
        return null;
    }

    private Slot getCorrespondingOldChildSlot(Property prop, InstanceSpecification inst) {
        if (inst == null) {
            return null;
        }
        EList slots = inst.getSlots();
        for (Slot s : slots) {
            if (s.getDefiningFeature() == null || !s.getDefiningFeature().equals(prop)) continue;
            return s;
        }
        return null;
    }

    private List<Comment> getAllCHRTSpec(Class umlClass, Property theProp) {
        EList commList = umlClass.getOwnedComments();
        ArrayList<Comment> mycommlist = new ArrayList<Comment>();
        for (Comment comm : commList) {
            mycommlist.add(comm);
        }
        if (theProp != null) {
            commList = ((Classifier)theProp.getFeaturingClassifiers().get(0)).getOwnedComments();
            for (Comment comm : commList) {
                mycommlist.add(comm);
            }
        }
        for (Operation op : umlClass.getOperations()) {
            commList = op.getOwnedComments();
            for (Comment comm : commList) {
                mycommlist.add(comm);
            }
        }
        return mycommlist;
    }
}

