/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.CDOCommonView;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.common.revision.CDOIDAndBranch;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.ILockingManager;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.server.InternalLockManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.spi.server.InternalStore;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.ConcurrentArray;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.concurrent.RWOLockManager;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.options.IOptionsContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockingManager
extends RWOLockManager<Object, IView>
implements InternalLockManager {
    private InternalRepository repository;
    private Map<String, InternalView> openViews = new HashMap<String, InternalView>();
    private Map<String, DurableView> durableViews = new HashMap<String, DurableView>();
    private ConcurrentArray<ILockingManager.DurableViewHandler> durableViewHandlers = new ConcurrentArray<ILockingManager.DurableViewHandler>(){

        protected ILockingManager.DurableViewHandler[] newArray(int length) {
            return new ILockingManager.DurableViewHandler[length];
        }
    };
    @ReflectUtil.ExcludeFromDump
    private transient IListener sessionListener = new ContainerEventAdapter<IView>(){

        protected void onRemoved(IContainer<IView> container, IView view) {
            String durableLockingID = view.getDurableLockingID();
            if (durableLockingID == null) {
                LockingManager.this.unlock(view);
            } else {
                DurableView durableView = new DurableView(durableLockingID);
                LockingManager.this.changeContext(view, durableView);
                LockingManager.this.unregisterOpenView(durableLockingID);
                LockingManager.this.durableViews.put(durableLockingID, durableView);
            }
        }
    };
    @ReflectUtil.ExcludeFromDump
    private transient IListener sessionManagerListener = new ContainerEventAdapter<ISession>(){

        protected void onAdded(IContainer<ISession> container, ISession session) {
            session.addListener(LockingManager.this.sessionListener);
        }

        protected void onRemoved(IContainer<ISession> container, ISession session) {
            session.removeListener(LockingManager.this.sessionListener);
        }
    };

    @Override
    public InternalRepository getRepository() {
        return this.repository;
    }

    @Override
    public void setRepository(InternalRepository repository) {
        this.repository = repository;
    }

    @Override
    public synchronized Object getLockEntryObject(Object key) {
        RWOLockManager.LockState lockState = (RWOLockManager.LockState)this.getObjectToLocksMap().get(key);
        return lockState == null ? null : lockState.getLockedObject();
    }

    @Override
    public Object getLockKey(CDOID id, CDOBranch branch) {
        if (this.repository.isSupportingBranches()) {
            return CDOIDUtil.createIDAndBranch((CDOID)id, (CDOBranch)branch);
        }
        return id;
    }

    @Override
    public synchronized Map<CDOID, IDurableLockingManager.LockGrade> getLocks(IView view) {
        Map result = CDOIDUtil.createMap();
        for (RWOLockManager.LockState lockState : this.getObjectToLocksMap().values()) {
            IDurableLockingManager.LockGrade grade = IDurableLockingManager.LockGrade.NONE;
            if (lockState.hasLock(IRWLockManager.LockType.READ, (Object)view, false)) {
                grade = grade.getUpdated(IRWLockManager.LockType.READ, true);
            }
            if (lockState.hasLock(IRWLockManager.LockType.WRITE, (Object)view, false)) {
                grade = grade.getUpdated(IRWLockManager.LockType.WRITE, true);
            }
            if (lockState.hasLock(IRWLockManager.LockType.OPTION, (Object)view, false)) {
                grade = grade.getUpdated(IRWLockManager.LockType.OPTION, true);
            }
            if (grade == IDurableLockingManager.LockGrade.NONE) continue;
            CDOID id = this.getLockKeyID(lockState.getLockedObject());
            result.put(id, grade);
        }
        return result;
    }

    @Override
    @Deprecated
    public void lock(boolean explicit, IRWLockManager.LockType type, IView view, Collection<? extends Object> objectsToLock, long timeout) throws InterruptedException {
        this.lock2(explicit, type, view, objectsToLock, false, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RWOLockManager.LockState<Object, IView>> lock2(boolean explicit, IRWLockManager.LockType type, IView view, Collection<? extends Object> objectsToLock, boolean recursive, long timeout) throws InterruptedException {
        List newLockStates;
        String durableLockingID = null;
        IStoreAccessor.DurableLocking accessor = null;
        if (explicit && (durableLockingID = view.getDurableLockingID()) != null) {
            accessor = this.getDurableLocking();
        }
        long startTime = timeout == 0L ? 0L : this.currentTimeMillis();
        LockingManager lockingManager = this;
        synchronized (lockingManager) {
            if (recursive) {
                objectsToLock = this.createContentSet(objectsToLock, view);
            }
            if (timeout != 0L) {
                timeout -= this.currentTimeMillis() - startTime;
            }
            newLockStates = super.lock2(type, (Object)view, objectsToLock, timeout);
        }
        if (accessor != null) {
            accessor.lock(durableLockingID, type, objectsToLock);
        }
        return newLockStates;
    }

    private Set<? extends Object> createContentSet(Collection<? extends Object> objectsToLock, IView view) {
        CDOBranch branch = view.getBranch();
        CDOView cdoView = CDOServerUtil.openView(view.getSession(), branch.getHead());
        HashSet<Object> contents = new HashSet<Object>();
        for (Object object : objectsToLock) {
            contents.add(object);
            boolean isIDandBranch = object instanceof CDOIDAndBranch;
            CDOID id = isIDandBranch ? ((CDOIDAndBranch)object).getID() : (CDOID)object;
            CDOObject obj = cdoView.getObject(id);
            TreeIterator iter = obj.eAllContents();
            while (iter.hasNext()) {
                EObject eObj = (EObject)iter.next();
                CDOObject cdoObj = CDOUtil.getCDOObject((EObject)eObj);
                CDOID childID = cdoObj.cdoID();
                Object child = isIDandBranch ? CDOIDUtil.createIDAndBranch((CDOID)childID, (CDOBranch)branch) : childID;
                contents.add(child);
            }
        }
        return contents;
    }

    @Override
    @Deprecated
    public synchronized void unlock(boolean explicit, IRWLockManager.LockType type, IView view, Collection<? extends Object> objectsToUnlock) {
        this.unlock2(explicit, type, view, objectsToUnlock, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<RWOLockManager.LockState<Object, IView>> unlock2(boolean explicit, IRWLockManager.LockType type, IView view, Collection<? extends Object> objects, boolean recursive) {
        String durableLockingID;
        List newLockStates;
        LockingManager lockingManager = this;
        synchronized (lockingManager) {
            if (recursive) {
                objects = this.createContentSet(objects, view);
            }
            newLockStates = super.unlock2(type, (Object)view, objects);
        }
        if (explicit && (durableLockingID = view.getDurableLockingID()) != null) {
            IStoreAccessor.DurableLocking accessor = this.getDurableLocking();
            accessor.unlock(durableLockingID, type, objects);
        }
        return newLockStates;
    }

    @Override
    @Deprecated
    public synchronized void unlock(boolean explicit, IView view) {
        this.unlock2(explicit, view);
    }

    @Override
    public synchronized List<RWOLockManager.LockState<Object, IView>> unlock2(boolean explicit, IView view) {
        String durableLockingID;
        if (explicit && (durableLockingID = view.getDurableLockingID()) != null) {
            IStoreAccessor.DurableLocking accessor = this.getDurableLocking();
            accessor.unlock(durableLockingID);
        }
        return super.unlock2((Object)view);
    }

    public IDurableLockingManager.LockArea createLockArea(String userID, CDOBranchPoint branchPoint, boolean readOnly, Map<CDOID, IDurableLockingManager.LockGrade> locks) {
        return this.createLockArea(userID, branchPoint, readOnly, locks, null);
    }

    private IDurableLockingManager.LockArea createLockArea(String userID, CDOBranchPoint branchPoint, boolean readOnly, Map<CDOID, IDurableLockingManager.LockGrade> locks, String lockAreaID) {
        if (lockAreaID == null) {
            IStoreAccessor.DurableLocking accessor = this.getDurableLocking();
            return accessor.createLockArea(userID, branchPoint, readOnly, locks);
        }
        IStoreAccessor.DurableLocking2 accessor = this.getDurableLocking2();
        return accessor.createLockArea(lockAreaID, userID, branchPoint, readOnly, locks);
    }

    @Override
    public IDurableLockingManager.LockArea createLockArea(InternalView view) {
        return this.createLockArea(view, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDurableLockingManager.LockArea createLockArea(InternalView view, String lockAreaID) {
        String userID = view.getSession().getUserID();
        CDOBranchPoint branchPoint = CDOBranchUtil.copyBranchPoint((CDOBranchPoint)view);
        boolean readOnly = view.isReadOnly();
        Map<CDOID, IDurableLockingManager.LockGrade> locks = this.getLocks(view);
        IDurableLockingManager.LockArea area = this.createLockArea(userID, branchPoint, readOnly, locks, lockAreaID);
        Map<String, InternalView> map = this.openViews;
        synchronized (map) {
            this.openViews.put(area.getDurableLockingID(), view);
        }
        return area;
    }

    public IDurableLockingManager.LockArea getLockArea(String durableLockingID) throws IDurableLockingManager.LockAreaNotFoundException {
        IStoreAccessor.DurableLocking accessor = this.getDurableLocking();
        return accessor.getLockArea(durableLockingID);
    }

    public void getLockAreas(String userIDPrefix, IDurableLockingManager.LockArea.Handler handler) {
        if (userIDPrefix == null) {
            userIDPrefix = "";
        }
        IStoreAccessor.DurableLocking accessor = this.getDurableLocking();
        accessor.getLockAreas(userIDPrefix, handler);
    }

    public void deleteLockArea(String durableLockingID) {
        IStoreAccessor.DurableLocking accessor = this.getDurableLocking();
        accessor.deleteLockArea(durableLockingID);
        this.unregisterOpenView(durableLockingID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IView openView(ISession session, int viewID, boolean readOnly, final String durableLockingID) {
        Map<String, InternalView> map = this.openViews;
        synchronized (map) {
            InternalView view = this.openViews.get(durableLockingID);
            if (view != null) {
                throw new IllegalStateException("Durable view is already open: " + view);
            }
            IDurableLockingManager.LockArea area = this.getLockArea(durableLockingID);
            if (area.isReadOnly() != readOnly) {
                throw new IllegalStateException("Durable read-only state does not match the request");
            }
            ILockingManager.DurableViewHandler[] durableViewHandlerArray = (ILockingManager.DurableViewHandler[])this.durableViewHandlers.get();
            int n = durableViewHandlerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILockingManager.DurableViewHandler handler = durableViewHandlerArray[n2];
                try {
                    handler.openingView(session, viewID, readOnly, area);
                }
                catch (Exception ex) {
                    throw WrappedException.wrap((Exception)ex);
                }
                ++n2;
            }
            view = readOnly ? (InternalView)session.openView(viewID, (CDOBranchPoint)area) : (InternalView)((Object)session.openTransaction(viewID, (CDOBranchPoint)area));
            DurableView durableView = this.durableViews.get(durableLockingID);
            this.changeContext(durableView, view);
            view.setDurableLockingID(durableLockingID);
            view.addListener((IListener)new LifecycleEventAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void onDeactivated(ILifecycle lifecycle) {
                    Map map = LockingManager.this.openViews;
                    synchronized (map) {
                        LockingManager.this.openViews.remove(durableLockingID);
                    }
                }
            });
            this.openViews.put(durableLockingID, view);
            return view;
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.loadLocks();
        this.getRepository().getSessionManager().addListener(this.sessionManagerListener);
    }

    protected void doDeactivate() throws Exception {
        InternalSessionManager sessionManager = this.getRepository().getSessionManager();
        sessionManager.removeListener(this.sessionManagerListener);
        ISession[] iSessionArray = sessionManager.getSessions();
        int n = iSessionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISession session = iSessionArray[n2];
            session.removeListener(this.sessionListener);
            ++n2;
        }
        super.doDeactivate();
    }

    private IStoreAccessor.DurableLocking getDurableLocking() {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        if (accessor instanceof IStoreAccessor.DurableLocking) {
            return (IStoreAccessor.DurableLocking)((Object)accessor);
        }
        throw new IllegalStateException("Store does not implement " + IStoreAccessor.DurableLocking.class.getSimpleName());
    }

    private IStoreAccessor.DurableLocking2 getDurableLocking2() {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        if (accessor instanceof IStoreAccessor.DurableLocking2) {
            return (IStoreAccessor.DurableLocking2)((Object)accessor);
        }
        throw new IllegalStateException("Store does not implement " + IStoreAccessor.DurableLocking2.class.getSimpleName());
    }

    @Override
    public void reloadLocks() {
        DurableLockLoader handler = new DurableLockLoader();
        this.getLockAreas(null, handler);
    }

    private void loadLocks() {
        InternalStore store = this.repository.getStore();
        IStoreAccessor reader = null;
        try {
            reader = store.getReader(null);
            if (reader instanceof IStoreAccessor.DurableLocking) {
                StoreThreadLocal.setAccessor(reader);
                this.reloadLocks();
            }
        }
        finally {
            StoreThreadLocal.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterOpenView(String durableLockingID) {
        Map<String, InternalView> map = this.openViews;
        synchronized (map) {
            InternalView view = this.openViews.remove(durableLockingID);
            if (view != null) {
                view.setDurableLockingID(null);
            }
        }
    }

    @Override
    public CDOID getLockKeyID(Object key) {
        if (key instanceof CDOID) {
            return (CDOID)key;
        }
        if (key instanceof CDOIDAndBranch) {
            return ((CDOIDAndBranch)key).getID();
        }
        throw new ImplementationError("Unexpected lock object: " + key);
    }

    @Override
    public void addDurableViewHandler(ILockingManager.DurableViewHandler handler) {
        this.durableViewHandlers.add((Object)handler);
    }

    @Override
    public void removeDurableViewHandler(ILockingManager.DurableViewHandler handler) {
        this.durableViewHandlers.remove((Object)handler);
    }

    @Override
    public ILockingManager.DurableViewHandler[] getDurableViewHandlers() {
        return (ILockingManager.DurableViewHandler[])this.durableViewHandlers.get();
    }

    @Override
    public IDurableLockingManager.LockGrade getLockGrade(Object key) {
        RWOLockManager.LockState lockState = (RWOLockManager.LockState)this.getObjectToLocksMap().get(key);
        IDurableLockingManager.LockGrade grade = IDurableLockingManager.LockGrade.NONE;
        if (lockState != null) {
            IRWLockManager.LockType[] lockTypeArray = IRWLockManager.LockType.values();
            int n = lockTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IRWLockManager.LockType type = lockTypeArray[n2];
                if (lockState.hasLock(type)) {
                    grade = grade.getUpdated(type, true);
                }
                ++n2;
            }
        }
        return grade;
    }

    private IDurableLockingManager.LockArea getLockAreaNoEx(String durableLockingID) {
        try {
            return this.getLockArea(durableLockingID);
        }
        catch (IDurableLockingManager.LockAreaNotFoundException e) {
            return null;
        }
    }

    @Override
    public void updateLockArea(IDurableLockingManager.LockArea lockArea) {
        String durableLockingID = lockArea.getDurableLockingID();
        IStoreAccessor.DurableLocking2 accessor = this.getDurableLocking2();
        if (lockArea.isMissing()) {
            IDurableLockingManager.LockArea localLockArea = this.getLockAreaNoEx(durableLockingID);
            if (localLockArea != null && localLockArea.getLocks().size() > 0) {
                accessor.deleteLockArea(durableLockingID);
                DurableView deletedView = this.durableViews.remove(durableLockingID);
                CheckUtil.checkNull((Object)deletedView, (String)"deletedView");
            }
        } else {
            accessor.updateLockArea(lockArea);
            new DurableLockLoader().handleLockArea(lockArea);
        }
    }

    private final class DurableLockLoader
    implements IDurableLockingManager.LockArea.Handler {
        private IView getView(String lockAreaID) {
            IView view = (IView)LockingManager.this.openViews.get(lockAreaID);
            if (view == null) {
                view = (IView)LockingManager.this.durableViews.get(lockAreaID);
            }
            return view;
        }

        public boolean handleLockArea(IDurableLockingManager.LockArea area) {
            String durableLockingID = area.getDurableLockingID();
            IView view = this.getView(durableLockingID);
            if (view != null) {
                LockingManager.this.unlock2(view);
            }
            if (view == null) {
                view = new DurableView(durableLockingID);
                LockingManager.this.durableViews.put(durableLockingID, (DurableView)view);
            }
            ArrayList<Object> readLocks = new ArrayList<Object>();
            ArrayList<Object> writeLocks = new ArrayList<Object>();
            ArrayList<Object> writeOptions = new ArrayList<Object>();
            for (Map.Entry entry : area.getLocks().entrySet()) {
                Object key = LockingManager.this.getLockKey((CDOID)entry.getKey(), area.getBranch());
                IDurableLockingManager.LockGrade grade = (IDurableLockingManager.LockGrade)entry.getValue();
                if (grade.isRead()) {
                    readLocks.add(key);
                }
                if (grade.isWrite()) {
                    writeLocks.add(key);
                }
                if (!grade.isOption()) continue;
                writeOptions.add(key);
            }
            try {
                LockingManager.this.lock(IRWLockManager.LockType.READ, view, readLocks, 1000L);
                LockingManager.this.lock(IRWLockManager.LockType.WRITE, view, writeLocks, 1000L);
                LockingManager.this.lock(IRWLockManager.LockType.OPTION, view, writeOptions, 1000L);
            }
            catch (InterruptedException ex) {
                throw WrappedException.wrap((Exception)ex);
            }
            return true;
        }
    }

    private final class DurableView
    extends PlatformObject
    implements IView,
    CDOCommonView.Options {
        private String durableLockingID;

        public DurableView(String durableLockingID) {
            this.durableLockingID = durableLockingID;
        }

        public String getDurableLockingID() {
            return this.durableLockingID;
        }

        public boolean isDurableView() {
            return true;
        }

        public int getSessionID() {
            throw new UnsupportedOperationException();
        }

        public int getViewID() {
            throw new UnsupportedOperationException();
        }

        public boolean isReadOnly() {
            throw new UnsupportedOperationException();
        }

        public CDOBranch getBranch() {
            throw new UnsupportedOperationException();
        }

        public long getTimeStamp() {
            throw new UnsupportedOperationException();
        }

        public CDORevision getRevision(CDOID id) {
            throw new UnsupportedOperationException();
        }

        public void close() {
            throw new UnsupportedOperationException();
        }

        public boolean isClosed() {
            throw new UnsupportedOperationException();
        }

        public IRepository getRepository() {
            throw new UnsupportedOperationException();
        }

        public ISession getSession() {
            return null;
        }

        public int hashCode() {
            return this.durableLockingID.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof DurableView) {
                DurableView that = (DurableView)obj;
                return this.durableLockingID.equals(that.getDurableLockingID());
            }
            return false;
        }

        public String toString() {
            return MessageFormat.format("DurableView[{0}]", this.durableLockingID);
        }

        public IOptionsContainer getContainer() {
            return null;
        }

        public void addListener(IListener listener) {
        }

        public void removeListener(IListener listener) {
        }

        public boolean hasListeners() {
            return false;
        }

        public IListener[] getListeners() {
            return null;
        }

        public CDOCommonView.Options options() {
            return this;
        }

        public boolean isLockNotificationEnabled() {
            return false;
        }

        public void setLockNotificationEnabled(boolean enabled) {
        }
    }
}

