/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XCatchClause;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XThrowExpression;
import org.eclipse.xtext.xbase.XTryCatchFinallyExpression;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.IThrownExceptionDelegate;
import org.eclipse.xtext.xbase.util.XbaseSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrownExceptionSwitch
extends XbaseSwitch<Boolean> {
    private IThrownExceptionDelegate delegate;

    public ThrownExceptionSwitch(IThrownExceptionDelegate delegate) {
        this.delegate = delegate;
    }

    protected void accept(LightweightTypeReference type) {
        this.delegate.accept(type);
    }

    protected LightweightTypeReference getType(XExpression expr) {
        return this.delegate.getActualType(expr);
    }

    @Override
    public Boolean defaultCase(EObject object) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean caseXExpression(XExpression object) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean caseXClosure(XClosure object) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean caseXCasePart(XCasePart object) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean caseXThrowExpression(XThrowExpression object) {
        this.accept(this.getType(object.getExpression()));
        return Boolean.TRUE;
    }

    @Override
    public Boolean caseXCatchClause(XCatchClause object) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean caseXTryCatchFinallyExpression(XTryCatchFinallyExpression object) {
        EList<XCatchClause> clauses = object.getCatchClauses();
        if (clauses.isEmpty()) {
            return Boolean.TRUE;
        }
        ArrayList caughtExceptions = Lists.newArrayList();
        boolean wasThrowable = false;
        for (XCatchClause clause : clauses) {
            JvmTypeReference caught = clause.getDeclaredParam().getParameterType();
            if (caught != null) {
                LightweightTypeReference caughtException = this.delegate.toLightweightReference(caught).getRawTypeReference();
                if (caughtException.isType(Throwable.class)) {
                    wasThrowable = true;
                }
                caughtExceptions.add(caughtException);
            }
            this.delegate.collectThrownExceptions(clause.getExpression());
        }
        this.delegate.collectThrownExceptions(object.getFinallyExpression());
        if (wasThrowable) {
            return Boolean.FALSE;
        }
        this.delegate.catchExceptions(caughtExceptions).collectThrownExceptions(object.getExpression());
        return Boolean.FALSE;
    }

    @Override
    public Boolean caseXAbstractFeatureCall(XAbstractFeatureCall object) {
        JvmIdentifiableElement feature = object.getFeature();
        if (feature instanceof JvmExecutable) {
            this.accept((JvmExecutable)feature);
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean caseXConstructorCall(XConstructorCall object) {
        JvmConstructor constructor = object.getConstructor();
        this.accept((JvmExecutable)constructor);
        return Boolean.TRUE;
    }

    protected void accept(JvmExecutable executable) {
        for (JvmTypeReference exception : executable.getExceptions()) {
            this.accept(this.delegate.toLightweightReference(exception).getRawTypeReference());
        }
    }
}

