/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.featurecalls;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.inject.Singleton;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Set;
import org.eclipse.xtext.naming.QualifiedName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class OperatorMapping {
    public static final QualifiedName PLUS = QualifiedName.create((String)"+");
    public static final QualifiedName PLUS_PLUS = QualifiedName.create((String)"++");
    public static final QualifiedName MINUS = QualifiedName.create((String)"-");
    public static final QualifiedName MINUS_MINUS = QualifiedName.create((String)"--");
    public static final QualifiedName POWER = QualifiedName.create((String)"**");
    public static final QualifiedName MULTIPLY = QualifiedName.create((String)"*");
    public static final QualifiedName DIVIDE = QualifiedName.create((String)"/");
    public static final QualifiedName MODULO = QualifiedName.create((String)"%");
    public static final QualifiedName DOUBLE_LESS_THAN = QualifiedName.create((String)"<<");
    public static final QualifiedName DOUBLE_GREATER_THAN = QualifiedName.create((String)">>");
    public static final QualifiedName TRIPLE_LESS_THAN = QualifiedName.create((String)"<<<");
    public static final QualifiedName TRIPLE_GREATER_THAN = QualifiedName.create((String)">>>");
    public static final QualifiedName ELVIS = QualifiedName.create((String)"?:");
    public static final QualifiedName DIAMOND = QualifiedName.create((String)"<>");
    public static final QualifiedName SPACESHIP = QualifiedName.create((String)"<=>");
    public static final QualifiedName OR = QualifiedName.create((String)"||");
    public static final QualifiedName AND = QualifiedName.create((String)"&&");
    public static final QualifiedName ADD = QualifiedName.create((String)"+=");
    public static final QualifiedName REMOVE = QualifiedName.create((String)"-=");
    public static final QualifiedName MULTIPLY_ASSIGN = QualifiedName.create((String)"*=");
    public static final QualifiedName DIVIDE_ASSIGN = QualifiedName.create((String)"/=");
    public static final QualifiedName MODULO_ASSIGN = QualifiedName.create((String)"%=");
    public static final QualifiedName DOUBLE_LESS_THAN_ASSIGN = QualifiedName.create((String)"<<=");
    public static final QualifiedName DOUBLE_GREATER_THAN_ASSIGN = QualifiedName.create((String)">>=");
    public static final QualifiedName TRIPLE_GREATER_THAN_ASSIGN = QualifiedName.create((String)">>>=");
    public static final QualifiedName EQUALS = QualifiedName.create((String)"==");
    public static final QualifiedName TRIPLE_EQUALS = QualifiedName.create((String)"===");
    public static final QualifiedName TRIPLE_NOT_EQUALS = QualifiedName.create((String)"!==");
    public static final QualifiedName NOT_EQUALS = QualifiedName.create((String)"!=");
    public static final QualifiedName LESS_THAN = QualifiedName.create((String)"<");
    public static final QualifiedName LESS_EQUALS_THAN = QualifiedName.create((String)"<=");
    public static final QualifiedName GREATER_THAN = QualifiedName.create((String)">");
    public static final QualifiedName GREATER_EQUALS_THAN = QualifiedName.create((String)">=");
    public static final QualifiedName MAPPED_TO = QualifiedName.create((String)"->");
    public static final QualifiedName UP_TO = QualifiedName.create((String)"..");
    public static final QualifiedName DOUBLE_DOT_LESS_THAN = QualifiedName.create((String)"..<");
    public static final QualifiedName GREATER_THAN_DOUBLE_DOT = QualifiedName.create((String)">..");
    public static final QualifiedName NOT = QualifiedName.create((String)"!");
    public static final QualifiedName DOUBLE_ARROW = QualifiedName.create((String)"=>");
    protected BiMap<QualifiedName, QualifiedName> map = HashBiMap.create();
    protected BiMap<QualifiedName, QualifiedName> compoundOperatorMapping = HashBiMap.create();
    public static final String OP_PREFIX = "operator_";

    public OperatorMapping() {
        this.initializeMapping();
    }

    protected void initializeMapping() {
        this.map.put((Object)PLUS, (Object)QualifiedName.create((String)"operator_plus"));
        this.map.put((Object)PLUS_PLUS, (Object)QualifiedName.create((String)"operator_plusPlus"));
        this.map.put((Object)MINUS, (Object)QualifiedName.create((String)"operator_minus"));
        this.map.put((Object)MINUS_MINUS, (Object)QualifiedName.create((String)"operator_minusMinus"));
        this.map.put((Object)POWER, (Object)QualifiedName.create((String)"operator_power"));
        this.map.put((Object)MULTIPLY, (Object)QualifiedName.create((String)"operator_multiply"));
        this.map.put((Object)DIVIDE, (Object)QualifiedName.create((String)"operator_divide"));
        this.map.put((Object)MODULO, (Object)QualifiedName.create((String)"operator_modulo"));
        this.map.put((Object)DOUBLE_LESS_THAN, (Object)QualifiedName.create((String)"operator_doubleLessThan"));
        this.map.put((Object)DOUBLE_GREATER_THAN, (Object)QualifiedName.create((String)"operator_doubleGreaterThan"));
        this.map.put((Object)TRIPLE_LESS_THAN, (Object)QualifiedName.create((String)"operator_tripleLessThan"));
        this.map.put((Object)TRIPLE_GREATER_THAN, (Object)QualifiedName.create((String)"operator_tripleGreaterThan"));
        this.map.put((Object)ELVIS, (Object)QualifiedName.create((String)"operator_elvis"));
        this.map.put((Object)DIAMOND, (Object)QualifiedName.create((String)"operator_diamond"));
        this.map.put((Object)SPACESHIP, (Object)QualifiedName.create((String)"operator_spaceship"));
        this.map.put((Object)OR, (Object)QualifiedName.create((String)"operator_or"));
        this.map.put((Object)AND, (Object)QualifiedName.create((String)"operator_and"));
        this.map.put((Object)ADD, (Object)QualifiedName.create((String)"operator_add"));
        this.map.put((Object)REMOVE, (Object)QualifiedName.create((String)"operator_remove"));
        this.map.put((Object)MULTIPLY_ASSIGN, (Object)QualifiedName.create((String)"operator_multiplyAssign"));
        this.map.put((Object)DIVIDE_ASSIGN, (Object)QualifiedName.create((String)"operator_divideAssign"));
        this.map.put((Object)MODULO_ASSIGN, (Object)QualifiedName.create((String)"operator_moduloAssign"));
        this.map.put((Object)DOUBLE_LESS_THAN_ASSIGN, (Object)QualifiedName.create((String)"operator_doubleLessThanAssign"));
        this.map.put((Object)DOUBLE_GREATER_THAN_ASSIGN, (Object)QualifiedName.create((String)"operator_doubleGreaterThanAssign"));
        this.map.put((Object)TRIPLE_GREATER_THAN_ASSIGN, (Object)QualifiedName.create((String)"operator_tripleGreaterThanAssign"));
        this.map.put((Object)EQUALS, (Object)QualifiedName.create((String)"operator_equals"));
        this.map.put((Object)TRIPLE_EQUALS, (Object)QualifiedName.create((String)"operator_tripleEquals"));
        this.map.put((Object)TRIPLE_NOT_EQUALS, (Object)QualifiedName.create((String)"operator_tripleNotEquals"));
        this.map.put((Object)NOT_EQUALS, (Object)QualifiedName.create((String)"operator_notEquals"));
        this.map.put((Object)LESS_THAN, (Object)QualifiedName.create((String)"operator_lessThan"));
        this.map.put((Object)LESS_EQUALS_THAN, (Object)QualifiedName.create((String)"operator_lessEqualsThan"));
        this.map.put((Object)GREATER_THAN, (Object)QualifiedName.create((String)"operator_greaterThan"));
        this.map.put((Object)GREATER_EQUALS_THAN, (Object)QualifiedName.create((String)"operator_greaterEqualsThan"));
        this.map.put((Object)MAPPED_TO, (Object)QualifiedName.create((String)"operator_mappedTo"));
        this.map.put((Object)UP_TO, (Object)QualifiedName.create((String)"operator_upTo"));
        this.map.put((Object)DOUBLE_DOT_LESS_THAN, (Object)QualifiedName.create((String)"operator_doubleDotLessThan"));
        this.map.put((Object)GREATER_THAN_DOUBLE_DOT, (Object)QualifiedName.create((String)"operator_greaterThanDoubleDot"));
        this.map.put((Object)NOT, (Object)QualifiedName.create((String)"operator_not"));
        this.map.put((Object)DOUBLE_ARROW, (Object)QualifiedName.create((String)"operator_doubleArrow"));
        this.compoundOperatorMapping.put((Object)ADD, (Object)PLUS);
        this.compoundOperatorMapping.put((Object)REMOVE, (Object)MINUS);
        this.compoundOperatorMapping.put((Object)MULTIPLY_ASSIGN, (Object)MULTIPLY);
        this.compoundOperatorMapping.put((Object)DIVIDE_ASSIGN, (Object)DIVIDE);
        this.compoundOperatorMapping.put((Object)MODULO_ASSIGN, (Object)MODULO);
        this.compoundOperatorMapping.put((Object)DOUBLE_LESS_THAN_ASSIGN, (Object)DOUBLE_LESS_THAN);
        this.compoundOperatorMapping.put((Object)DOUBLE_GREATER_THAN_ASSIGN, (Object)DOUBLE_GREATER_THAN);
        this.compoundOperatorMapping.put((Object)TRIPLE_GREATER_THAN_ASSIGN, (Object)TRIPLE_GREATER_THAN);
    }

    public QualifiedName getMethodName(QualifiedName operator) {
        return (QualifiedName)this.map.get((Object)operator);
    }

    public QualifiedName getOperator(QualifiedName methodName) {
        return (QualifiedName)this.map.inverse().get((Object)methodName);
    }

    public Set<QualifiedName> getOperators() {
        return this.map.keySet();
    }

    public QualifiedName getCompoundOperator(QualifiedName simpleOperator) {
        return (QualifiedName)this.compoundOperatorMapping.inverse().get((Object)simpleOperator);
    }

    public Set<QualifiedName> getCompoundOperators() {
        return this.compoundOperatorMapping.keySet();
    }

    public QualifiedName getSimpleOperator(QualifiedName compoundOperator) {
        return (QualifiedName)this.compoundOperatorMapping.get((Object)compoundOperator);
    }

    public boolean isCompoundMethod(String methodName) {
        QualifiedName operator = this.getOperator(QualifiedName.create((String)methodName));
        return this.getCompoundOperators().contains(operator);
    }

    public boolean isBinaryOperator(QualifiedName operator) {
        return operator.equals((Object)MINUS) || operator.equals((Object)PLUS) || !this.isUnaryOperator(operator);
    }

    public boolean isUnaryOperator(QualifiedName operator) {
        return operator.equals((Object)PLUS_PLUS) || operator.equals((Object)MINUS_MINUS) || operator.equals((Object)MINUS) || operator.equals((Object)PLUS) || operator.equals((Object)NOT);
    }

    private static class JavaDocGenerator {
        private JavaDocGenerator() {
        }

        public static void main(String[] args) throws Exception {
            System.out.println(" * <table>");
            System.out.println(" *   <tr><th>Operator</th><th>Method Name</th></tr>");
            Field[] fields = OperatorMapping.class.getFields();
            BiMap<QualifiedName, QualifiedName> map = new OperatorMapping().map;
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (Modifier.isStatic(field.getModifiers()) && field.getType().equals(QualifiedName.class)) {
                    Object operator = field.get(null);
                    QualifiedName methodName = (QualifiedName)map.get(operator);
                    System.out.println(" *   <tr><td>" + JavaDocGenerator.toHtml(operator) + "</td><td>" + JavaDocGenerator.toHtml(methodName) + "</td></tr>");
                }
                ++n2;
            }
            System.out.println(" * </table>");
        }

        private static String toHtml(Object object) {
            String result = String.valueOf(object);
            result = result.replace("<", "&lt;").replace(">", "&gt;");
            return result;
        }
    }
}

