/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.CellVisualChangeEvent;
import org.eclipse.nebula.widgets.nattable.util.ICalculatedValueCacheKey;
import org.eclipse.nebula.widgets.nattable.util.ICalculator;

public class CalculatedValueCache {
    private ILayer layer;
    private ExecutorService executor;
    private Map<ICalculatedValueCacheKey, Object> cache = new HashMap<ICalculatedValueCacheKey, Object>();
    private Map<ICalculatedValueCacheKey, Object> cacheCopy = new HashMap<ICalculatedValueCacheKey, Object>();
    private final boolean useColumnAsKey;
    private final boolean useRowAsKey;
    private final boolean smoothUpdates;

    public CalculatedValueCache(ILayer layer, boolean useColumnAsKey, boolean useRowAsKey) {
        this(layer, useColumnAsKey, useRowAsKey, true);
    }

    public CalculatedValueCache(ILayer layer, boolean useColumnAsKey, boolean useRowAsKey, boolean smoothUpdates) {
        this.layer = layer;
        this.executor = Executors.newCachedThreadPool();
        this.useColumnAsKey = useColumnAsKey;
        this.useRowAsKey = useRowAsKey;
        this.smoothUpdates = smoothUpdates;
    }

    public Object getCalculatedValue(int columnPosition, int rowPosition, boolean calculateInBackground, ICalculator calculator) {
        ICalculatedValueCacheKey key = null;
        if (this.useColumnAsKey && this.useRowAsKey) {
            key = new CoordinateValueCacheKey(columnPosition, rowPosition);
        } else if (this.useColumnAsKey && !this.useRowAsKey) {
            key = new PositionValueCacheKey(columnPosition);
        } else if (!this.useColumnAsKey && this.useRowAsKey) {
            key = new PositionValueCacheKey(rowPosition);
        } else {
            throw new IllegalStateException("CalculatedValueCacheKey is configured to not use column or row position. Use getCalculatedValue() with ICalculatedValueCacheKey parameter instead.");
        }
        return this.getCalculatedValue(columnPosition, rowPosition, key, calculateInBackground, calculator);
    }

    public Object getCalculatedValue(final int columnPosition, final int rowPosition, final ICalculatedValueCacheKey key, boolean calculateInBackground, final ICalculator calculator) {
        Object result = null;
        if (calculateInBackground) {
            Object cacheCopyValue;
            Object cacheValue = this.cache.get(key);
            result = cacheCopyValue = this.cacheCopy.get(key);
            if (cacheCopyValue == null || !this.cacheValuesEqual(cacheValue, cacheCopyValue)) {
                if (!this.smoothUpdates) {
                    result = null;
                }
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        Object summaryValue = calculator.executeCalculation();
                        CalculatedValueCache.this.addToCache(key, summaryValue);
                        if (!CalculatedValueCache.this.cacheValuesEqual(summaryValue, cacheCopyValue) && CalculatedValueCache.this.layer != null) {
                            CalculatedValueCache.this.layer.fireLayerEvent(new CellVisualChangeEvent(CalculatedValueCache.this.layer, columnPosition, rowPosition));
                        }
                    }
                });
            }
        } else {
            result = calculator.executeCalculation();
            this.addToCache(key, result);
        }
        return result;
    }

    public void clearCache() {
        this.cache.clear();
    }

    public void killCache() {
        this.cache.clear();
        this.cacheCopy.clear();
    }

    protected void addToCache(ICalculatedValueCacheKey key, Object value) {
        this.cache.put(key, value);
        this.cacheCopy.put(key, value);
    }

    public void dispose() {
        this.executor.shutdownNow();
    }

    private boolean cacheValuesEqual(Object value1, Object value2) {
        return value1 == null && value2 == null || value1 != null && value2 != null && value1.equals(value2);
    }

    public void setLayer(ILayer layer) {
        this.layer = layer;
    }

    class CoordinateValueCacheKey
    implements ICalculatedValueCacheKey {
        private final int columnPosition;
        private final int rowPosition;

        public CoordinateValueCacheKey(int columnPosition, int rowPosition) {
            this.columnPosition = columnPosition;
            this.rowPosition = rowPosition;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + this.columnPosition;
            result = 31 * result + this.rowPosition;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CoordinateValueCacheKey other = (CoordinateValueCacheKey)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.columnPosition != other.columnPosition) {
                return false;
            }
            return this.rowPosition == other.rowPosition;
        }

        private CalculatedValueCache getOuterType() {
            return CalculatedValueCache.this;
        }
    }

    class PositionValueCacheKey
    implements ICalculatedValueCacheKey {
        private final int position;

        public PositionValueCacheKey(int position) {
            this.position = position;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + this.position;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PositionValueCacheKey other = (PositionValueCacheKey)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return this.position == other.position;
        }

        private CalculatedValueCache getOuterType() {
            return CalculatedValueCache.this;
        }
    }
}

