/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.painter;

import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.painter.IOverlayPainter;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public class NatTableBorderOverlayPainter
implements IOverlayPainter {
    private final Color borderColor;
    private final boolean renderAllBorderLines;
    private final IConfigRegistry configRegistry;

    public NatTableBorderOverlayPainter() {
        this(GUIHelper.COLOR_GRAY);
    }

    public NatTableBorderOverlayPainter(IConfigRegistry configRegistry) {
        this(GUIHelper.COLOR_GRAY, configRegistry);
    }

    public NatTableBorderOverlayPainter(boolean renderAllBorderLines) {
        this(GUIHelper.COLOR_GRAY, renderAllBorderLines);
    }

    public NatTableBorderOverlayPainter(boolean renderAllBorderLines, IConfigRegistry configRegistry) {
        this(GUIHelper.COLOR_GRAY, renderAllBorderLines, configRegistry);
    }

    public NatTableBorderOverlayPainter(Color borderColor) {
        this(borderColor, false);
    }

    public NatTableBorderOverlayPainter(Color borderColor, IConfigRegistry configRegistry) {
        this(borderColor, false, configRegistry);
    }

    public NatTableBorderOverlayPainter(Color borderColor, boolean renderAllBorderLines) {
        this(borderColor, renderAllBorderLines, null);
    }

    public NatTableBorderOverlayPainter(Color borderColor, boolean renderAllBorderLines, IConfigRegistry configRegistry) {
        this.borderColor = borderColor;
        this.renderAllBorderLines = renderAllBorderLines;
        this.configRegistry = configRegistry;
    }

    @Override
    public void paintOverlay(GC gc, ILayer layer) {
        Color beforeColor = gc.getForeground();
        gc.setForeground(this.getBorderColor());
        gc.drawLine(0, 0, 0, layer.getHeight() - 1);
        gc.drawLine(0, 0, layer.getWidth() - 1, 0);
        if (this.renderAllBorderLines) {
            gc.drawLine(layer.getWidth() - 1, 0, layer.getWidth() - 1, layer.getHeight() - 1);
            gc.drawLine(0, layer.getHeight() - 1, layer.getWidth() - 1, layer.getHeight() - 1);
        }
        gc.setForeground(beforeColor);
    }

    protected Color getBorderColor() {
        Color bColor;
        if (this.configRegistry != null && (bColor = this.configRegistry.getConfigAttribute(CellConfigAttributes.GRID_LINE_COLOR, "NORMAL", new String[0])) != null) {
            return bColor;
        }
        return this.borderColor;
    }
}

