/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.nebula.widgets.nattable.persistence.IPersistable;

public class SizeConfig
implements IPersistable {
    public static final String PERSISTENCE_KEY_DEFAULT_SIZE = ".defaultSize";
    public static final String PERSISTENCE_KEY_DEFAULT_SIZES = ".defaultSizes";
    public static final String PERSISTENCE_KEY_SIZES = ".sizes";
    public static final String PERSISTENCE_KEY_RESIZABLE_BY_DEFAULT = ".resizableByDefault";
    public static final String PERSISTENCE_KEY_RESIZABLE_INDEXES = ".resizableIndexes";
    public static final String PERSISTENCE_KEY_PERCENTAGE_SIZING = ".percentageSizing";
    public static final String PERSISTENCE_KEY_PERCENTAGE_SIZING_INDEXES = ".percentageSizingIndexes";
    private int defaultSize;
    private final Map<Integer, Integer> defaultSizeMap = new TreeMap<Integer, Integer>();
    private final Map<Integer, Integer> sizeMap = new TreeMap<Integer, Integer>();
    private final Map<Integer, Boolean> resizablesMap = new TreeMap<Integer, Boolean>();
    private boolean resizableByDefault = true;
    private final Map<Integer, Boolean> percentageSizingMap = new TreeMap<Integer, Boolean>();
    private boolean percentageSizing = false;
    private int availableSpace = -1;
    private final Map<Integer, Integer> realSizeMap = new TreeMap<Integer, Integer>();
    private final Map<Integer, Integer> aggregatedSizeCacheMap = new HashMap<Integer, Integer>();
    private boolean isAggregatedSizeCacheValid = true;

    public SizeConfig(int defaultSize) {
        this.defaultSize = defaultSize;
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        properties.put(String.valueOf(prefix) + PERSISTENCE_KEY_DEFAULT_SIZE, String.valueOf(this.defaultSize));
        this.saveMap(this.defaultSizeMap, String.valueOf(prefix) + PERSISTENCE_KEY_DEFAULT_SIZES, properties);
        this.saveMap(this.sizeMap, String.valueOf(prefix) + PERSISTENCE_KEY_SIZES, properties);
        properties.put(String.valueOf(prefix) + PERSISTENCE_KEY_RESIZABLE_BY_DEFAULT, String.valueOf(this.resizableByDefault));
        this.saveMap(this.resizablesMap, String.valueOf(prefix) + PERSISTENCE_KEY_RESIZABLE_INDEXES, properties);
        properties.put(String.valueOf(prefix) + PERSISTENCE_KEY_PERCENTAGE_SIZING, String.valueOf(this.percentageSizing));
        this.saveMap(this.percentageSizingMap, String.valueOf(prefix) + PERSISTENCE_KEY_PERCENTAGE_SIZING_INDEXES, properties);
    }

    private void saveMap(Map<Integer, ?> map, String key, Properties properties) {
        if (map.size() > 0) {
            StringBuilder strBuilder = new StringBuilder();
            for (Integer index : map.keySet()) {
                strBuilder.append(index);
                strBuilder.append(':');
                strBuilder.append(map.get(index));
                strBuilder.append(',');
            }
            properties.setProperty(key, strBuilder.toString());
        }
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        String persistedPercentageSizing;
        String persistedResizableDefault;
        this.defaultSizeMap.clear();
        this.sizeMap.clear();
        this.resizablesMap.clear();
        this.aggregatedSizeCacheMap.clear();
        String persistedDefaultSize = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_DEFAULT_SIZE);
        if (!StringUtils.isEmpty((String)persistedDefaultSize)) {
            this.defaultSize = Integer.valueOf(persistedDefaultSize);
        }
        if (!StringUtils.isEmpty((String)(persistedResizableDefault = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_RESIZABLE_BY_DEFAULT)))) {
            this.resizableByDefault = Boolean.valueOf(persistedResizableDefault);
        }
        if (!StringUtils.isEmpty((String)(persistedPercentageSizing = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_PERCENTAGE_SIZING)))) {
            this.setPercentageSizing(Boolean.valueOf(persistedPercentageSizing));
        }
        this.loadBooleanMap(String.valueOf(prefix) + PERSISTENCE_KEY_RESIZABLE_INDEXES, properties, this.resizablesMap);
        this.loadIntegerMap(String.valueOf(prefix) + PERSISTENCE_KEY_DEFAULT_SIZES, properties, this.defaultSizeMap);
        this.loadIntegerMap(String.valueOf(prefix) + PERSISTENCE_KEY_SIZES, properties, this.sizeMap);
        this.loadBooleanMap(String.valueOf(prefix) + PERSISTENCE_KEY_PERCENTAGE_SIZING_INDEXES, properties, this.percentageSizingMap);
    }

    private void loadIntegerMap(String key, Properties properties, Map<Integer, Integer> map) {
        String property = properties.getProperty(key);
        if (property != null) {
            map.clear();
            StringTokenizer tok = new StringTokenizer(property, ",");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                int separatorIndex = token.indexOf(58);
                map.put(Integer.valueOf(token.substring(0, separatorIndex)), Integer.valueOf(token.substring(separatorIndex + 1)));
            }
        }
    }

    private void loadBooleanMap(String key, Properties properties, Map<Integer, Boolean> map) {
        String property = properties.getProperty(key);
        if (property != null) {
            StringTokenizer tok = new StringTokenizer(property, ",");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                int separatorIndex = token.indexOf(58);
                map.put(Integer.valueOf(token.substring(0, separatorIndex)), Boolean.valueOf(token.substring(separatorIndex + 1)));
            }
        }
    }

    public void setDefaultSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        this.defaultSize = size;
        this.isAggregatedSizeCacheValid = false;
    }

    public void setDefaultSize(int position, int size) {
        if (this.defaultSize < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        this.defaultSizeMap.put(position, size);
        this.isAggregatedSizeCacheValid = false;
    }

    private int getDefaultSize(int position) {
        Integer size = this.defaultSizeMap.get(position);
        if (size != null) {
            return size;
        }
        return this.defaultSize;
    }

    public int getAggregateSize(int position) {
        if (position < 0) {
            return -1;
        }
        if (position == 0) {
            return 0;
        }
        if (this.isAllPositionsSameSize() && !this.isPercentageSizing()) {
            return position * this.defaultSize;
        }
        if (!this.isAggregatedSizeCacheValid) {
            this.aggregatedSizeCacheMap.clear();
            this.isAggregatedSizeCacheValid = true;
        }
        if (!this.aggregatedSizeCacheMap.containsKey(position)) {
            int aggregatedSize = this.calculateAggregatedSize(position);
            this.aggregatedSizeCacheMap.put(position, aggregatedSize);
        }
        return this.aggregatedSizeCacheMap.get(position);
    }

    public int getSize(int position) {
        Integer size = this.isPercentageSizing() ? this.realSizeMap.get(position) : this.sizeMap.get(position);
        if (size != null) {
            return size;
        }
        return this.getDefaultSize(position);
    }

    public void setSize(int position, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        if (this.isPositionResizable(position)) {
            if (!this.isPercentageSizing(position)) {
                this.sizeMap.put(position, size);
            } else if (this.availableSpace > 0) {
                Double percentage = (double)size * 100.0 / (double)this.availableSpace;
                Integer oldValue = this.sizeMap.get(position);
                int diff = percentage.intValue();
                if (oldValue != null) {
                    diff -= oldValue.intValue();
                } else if (this.realSizeMap.containsKey(position)) {
                    Double calculated = (double)this.realSizeMap.get(position).intValue() * 100.0 / (double)this.availableSpace;
                    diff -= calculated.intValue();
                }
                this.sizeMap.put(position, percentage.intValue());
                int nextPosition = position + 1;
                while (diff != 0 && this.realSizeMap.containsKey(nextPosition)) {
                    diff = this.updateAdjacentPosition(nextPosition, diff);
                    ++nextPosition;
                }
                int previousPosition = position - 1;
                while (diff != 0 && this.realSizeMap.containsKey(previousPosition)) {
                    diff = this.updateAdjacentPosition(previousPosition, diff);
                    --previousPosition;
                }
                if (diff != 0 && oldValue == null) {
                    this.sizeMap.remove(position);
                }
            }
            this.calculatePercentages(this.availableSpace, this.realSizeMap.size());
            this.isAggregatedSizeCacheValid = false;
        }
    }

    private int updateAdjacentPosition(int position, int diff) {
        if ((this.sizeMap.containsKey(position) || this.realSizeMap.containsKey(position)) && this.isPercentageSizing(position)) {
            if (this.sizeMap.containsKey(position)) {
                int currentValue = this.sizeMap.get(position);
                if (diff < currentValue) {
                    this.sizeMap.put(position, currentValue - diff);
                    return 0;
                }
                diff -= currentValue + 1;
                this.sizeMap.put(position, 1);
            }
            return 0;
        }
        return diff;
    }

    public void setPercentage(int position, int percentage) {
        if (percentage < 0) {
            throw new IllegalArgumentException("percentage < 0");
        }
        if (this.isPositionResizable(position)) {
            this.percentageSizingMap.put(position, Boolean.TRUE);
            this.sizeMap.put(position, percentage);
            this.realSizeMap.put(position, this.calculatePercentageValue(percentage, this.availableSpace));
            this.calculatePercentages(this.availableSpace, this.realSizeMap.size());
        }
    }

    public boolean isResizableByDefault() {
        return this.resizableByDefault;
    }

    public boolean isPositionResizable(int position) {
        Boolean resizable = this.resizablesMap.get(position);
        if (resizable != null) {
            return resizable;
        }
        return this.resizableByDefault;
    }

    public void setPositionResizable(int position, boolean resizable) {
        this.resizablesMap.put(position, resizable);
    }

    public void setResizableByDefault(boolean resizableByDefault) {
        this.resizablesMap.clear();
        this.resizableByDefault = resizableByDefault;
    }

    public boolean isAllPositionsSameSize() {
        return this.defaultSizeMap.size() == 0 && this.sizeMap.size() == 0;
    }

    public boolean isPercentageSizing() {
        if (!this.percentageSizingMap.isEmpty()) {
            for (Boolean pSize : this.percentageSizingMap.values()) {
                if (!pSize.booleanValue()) continue;
                return true;
            }
        }
        return this.percentageSizing;
    }

    public void setPercentageSizing(boolean percentageSizing) {
        this.percentageSizing = percentageSizing;
        this.isAggregatedSizeCacheValid = false;
    }

    public boolean isPercentageSizing(int position) {
        Boolean percentageSizing = this.percentageSizingMap.get(position);
        if (percentageSizing != null) {
            return percentageSizing;
        }
        return this.percentageSizing;
    }

    public void setPercentageSizing(int position, boolean percentageSizing) {
        this.percentageSizingMap.put(position, percentageSizing);
        this.isAggregatedSizeCacheValid = false;
    }

    public void calculatePercentages(int space, int positionCount) {
        if (this.isPercentageSizing()) {
            this.isAggregatedSizeCacheValid = false;
            this.availableSpace = space;
            int percentageSpace = this.calculateAvailableSpace(space);
            int sum = 0;
            int real = 0;
            int realSum = 0;
            int fixedSum = 0;
            ArrayList<Integer> noInfoPositions = new ArrayList<Integer>();
            Integer positionValue = null;
            int i = 0;
            while (i < positionCount) {
                positionValue = this.sizeMap.get(i);
                if (positionValue != null) {
                    if (this.isPercentageSizing(i)) {
                        sum += positionValue.intValue();
                        real = this.calculatePercentageValue(positionValue, percentageSpace);
                    } else {
                        real = positionValue;
                        fixedSum += real;
                    }
                    realSum += real;
                    this.realSizeMap.put(i, real);
                } else {
                    noInfoPositions.add(i);
                }
                ++i;
            }
            int[] correction = this.correctPercentageValues(sum, positionCount);
            if (correction != null) {
                sum = correction[0];
                realSum = correction[1] + fixedSum;
            }
            if (!noInfoPositions.isEmpty()) {
                double remaining = new Double(space) - (double)realSum;
                Double remainingColSpace = remaining / (double)noInfoPositions.size();
                for (Integer position : noInfoPositions) {
                    sum = (int)((double)sum + remainingColSpace / (double)space * 100.0);
                    this.realSizeMap.put(position, remainingColSpace.intValue());
                }
                sum = 100;
            }
            if (sum == 100) {
                int valueSum = 0;
                int lastPos = -1;
                for (Map.Entry<Integer, Integer> entry : this.realSizeMap.entrySet()) {
                    valueSum += entry.getValue().intValue();
                    lastPos = Math.max(lastPos, entry.getKey());
                }
                if (valueSum < space) {
                    int lastPosValue = this.realSizeMap.get(lastPos);
                    this.realSizeMap.put(lastPos, lastPosValue + (space - valueSum));
                }
            }
        }
    }

    private int calculatePercentageValue(int percentage, int space) {
        double factor = (double)percentage / 100.0;
        return new Double((double)space * factor).intValue();
    }

    private int calculateAvailableSpace(int space) {
        if (!this.percentageSizingMap.isEmpty() && this.percentageSizing) {
            for (Map.Entry<Integer, Boolean> entry : this.percentageSizingMap.entrySet()) {
                if (entry.getValue().booleanValue() || !this.sizeMap.containsKey(entry.getKey())) continue;
                space -= this.sizeMap.get(entry.getKey()).intValue();
            }
        }
        return space;
    }

    private int[] correctPercentageValues(int sum, int positionCount) {
        TreeMap<Integer, Integer> toModify = new TreeMap<Integer, Integer>();
        int i = 0;
        while (i < positionCount) {
            Integer positionValue = this.sizeMap.get(i);
            if (positionValue != null && this.isPercentageSizing(i)) {
                toModify.put(i, this.realSizeMap.get(i));
            }
            ++i;
        }
        if (sum > 100) {
            double factor = Double.valueOf(100.0) / Double.valueOf(sum);
            int realSum = 0;
            for (Map.Entry mod : toModify.entrySet()) {
                int oldValue = (Integer)mod.getValue();
                int newValue = Double.valueOf((double)oldValue * factor).intValue();
                realSum += newValue;
                this.realSizeMap.put((Integer)mod.getKey(), newValue);
            }
            return new int[]{100, realSum};
        }
        return null;
    }

    private int calculateAggregatedSize(int position) {
        int resizeAggregate = 0;
        int resizedColumns = 0;
        Map<Integer, Integer> mapToUse = this.isPercentageSizing() ? this.realSizeMap : this.sizeMap;
        for (Integer resizedPosition : mapToUse.keySet()) {
            if (resizedPosition >= position) break;
            ++resizedColumns;
            resizeAggregate += mapToUse.get(resizedPosition).intValue();
        }
        for (Integer defaultPosition : this.defaultSizeMap.keySet()) {
            if (defaultPosition >= position) break;
            if (mapToUse.containsKey(defaultPosition)) continue;
            ++resizedColumns;
            resizeAggregate += this.defaultSizeMap.get(defaultPosition).intValue();
        }
        return position * this.defaultSize + (resizeAggregate - resizedColumns * this.defaultSize);
    }
}

