/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.cdo.common.model.CDOPackageTypeRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.internal.ui.bundle.OM;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.widgets.BaseDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectPackageDialog
extends BaseDialog<CheckboxTableViewer> {
    private static final Set<String> NO_URIS = Collections.emptySet();
    private Set<String> excludedURIs = new HashSet<String>();
    private Set<String> checkedURIs = new HashSet<String>();

    public SelectPackageDialog(Shell shell, String title, String message, Set<String> excludedURIs) {
        super(shell, 66800, title, message, OM.Activator.INSTANCE.getDialogSettings());
        this.excludedURIs = excludedURIs;
    }

    public SelectPackageDialog(Shell shell, String title, String message) {
        this(shell, title, message, NO_URIS);
    }

    public Set<String> getCheckedURIs() {
        return this.checkedURIs;
    }

    protected void createUI(Composite parent) {
        CheckboxTableViewer viewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2052);
        viewer.getTable().setLayoutData((Object)UIUtil.createGridData());
        viewer.setContentProvider((IContentProvider)new PackageContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new PackageLabelProvider());
        viewer.setInput((Object)EPackage.Registry.INSTANCE);
        Object[] uris = (String[])OM.PREF_HISTORY_SELECT_PACKAGES.getValue();
        if (uris != null) {
            viewer.setCheckedElements(uris);
        }
        this.setCurrentViewer((Viewer)viewer);
    }

    protected void okPressed() {
        Object[] checkedElements;
        Object[] objectArray = checkedElements = ((CheckboxTableViewer)this.getCurrentViewer()).getCheckedElements();
        int n = checkedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object checkedElement = objectArray[n2];
            this.checkedURIs.add((String)checkedElement);
            ++n2;
        }
        OM.PREF_HISTORY_SELECT_PACKAGES.setValue((Object)this.checkedURIs.toArray(new String[this.checkedURIs.size()]));
        super.okPressed();
    }

    private class PackageContentProvider
    implements IStructuredContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            HashSet uris = new HashSet(EPackage.Registry.INSTANCE.keySet());
            uris.removeAll(SelectPackageDialog.this.excludedURIs);
            ArrayList elements = new ArrayList(uris);
            Collections.sort(elements);
            return elements.toArray();
        }
    }

    private class PackageLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        private final Color red = Display.getCurrent().getSystemColor(12);

        public String getText(Object element) {
            return element.toString();
        }

        public Image getImage(Object element) {
            if (element instanceof String) {
                CDOPackageUnit.Type type = CDOPackageTypeRegistry.INSTANCE.lookup((String)element);
                switch (type) {
                    case LEGACY: {
                        return SharedIcons.getImage((String)"obj16/EPackageLegacy.gif");
                    }
                    case NATIVE: {
                        return SharedIcons.getImage((String)"obj16/EPackageNative.gif");
                    }
                    case DYNAMIC: {
                        return SharedIcons.getImage((String)"obj16/EPackageDynamic.gif");
                    }
                    case UNKNOWN: {
                        return SharedIcons.getImage((String)"obj16/EPackageUnknown.gif");
                    }
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return this.getText(element);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return this.getImage(element);
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            if (EcorePackage.eINSTANCE.getNsURI().equals(element)) {
                return this.red;
            }
            return null;
        }
    }
}

