/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.papyrus.customization.properties.Activator;
import org.eclipse.papyrus.customization.properties.storage.actions.IContextCopyAction;
import org.eclipse.papyrus.views.properties.contexts.Context;
import org.eclipse.papyrus.views.properties.runtime.ConfigurationManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.statushandlers.StatusManager;

public class CopyContextAction {
    private IContextCopyAction delegate;

    public CopyContextAction(IContextCopyAction delegate) {
        this.delegate = delegate;
    }

    public Context copy(final Context source, final String targetName, final boolean activate) {
        final Context[] result = new Context[1];
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        try {
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        result[0] = CopyContextAction.this.delegate.copy(source, targetName, monitor);
                        if (result[0] != null) {
                            ConfigurationManager.getInstance().addContext(result[0], activate);
                            if (activate) {
                                ConfigurationManager.getInstance().disableContext(source, true);
                            }
                        }
                    }
                    catch (CoreException ex) {
                        throw new InvocationTargetException(ex);
                    }
                }
            });
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof CoreException) {
                CoreException ce = (CoreException)ex.getTargetException();
                Activator.log.error((Throwable)ce);
                StatusManager.getManager().handle(ce.getStatus(), 2);
            } else {
                Activator.log.error((Throwable)ex);
            }
        }
        catch (InterruptedException ex) {
            Activator.log.error((Throwable)ex);
        }
        return result[0];
    }
}

