/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.editor;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.views.properties.contexts.DataContextElement;
import org.eclipse.papyrus.views.properties.contexts.DataContextPackage;
import org.eclipse.papyrus.views.properties.contexts.View;
import org.eclipse.ui.internal.misc.StringMatcher;

public class ViewFilter
extends ViewerFilter {
    private StringMatcher matcher;

    public void setPattern(String pattern) {
        this.matcher = new StringMatcher("*" + pattern + "*", true, false);
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.matcher == null) {
            return true;
        }
        EObject semantic = EMFHelper.getEObject((Object)element);
        if (semantic != null) {
            if (semantic instanceof View) {
                String viewName = ((View)semantic).getName();
                if (viewName == null) {
                    return true;
                }
                return this.matcher.match(viewName);
            }
            if (semantic instanceof DataContextPackage) {
                return this.select((DataContextPackage)semantic);
            }
            if (semantic instanceof DataContextElement) {
                return this.select((DataContextElement)semantic);
            }
        }
        return true;
    }

    private boolean select(DataContextPackage dataContextPackage) {
        if (dataContextPackage.getName() == null) {
            return true;
        }
        if (this.matcher.match(dataContextPackage.getName())) {
            return true;
        }
        for (DataContextElement subElement : dataContextPackage.getElements()) {
            if (subElement instanceof DataContextPackage && this.select((DataContextPackage)subElement)) {
                return true;
            }
            if (!this.select(subElement)) continue;
            return true;
        }
        return false;
    }

    private boolean select(DataContextElement dataContextElement) {
        if (dataContextElement.getName() == null) {
            return true;
        }
        if (this.matcher.match(dataContextElement.getName())) {
            return true;
        }
        DataContextPackage dataContextPackage = dataContextElement.getPackage();
        while (dataContextPackage != null) {
            if (this.matcher.match(dataContextPackage.getName())) {
                return true;
            }
            dataContextPackage = dataContextPackage.getPackage();
        }
        return false;
    }
}

