/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.handlers;

import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ParameterValuesException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.AdapterUtils;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeManager;
import org.eclipse.papyrus.infra.services.controlmode.ControlModePlugin;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.IControlModeManager;
import org.eclipse.papyrus.infra.services.controlmode.commands.ControlModeCommandParameterValues;
import org.eclipse.papyrus.infra.services.controlmode.ui.IControlModeFragmentDialogProvider;
import org.eclipse.papyrus.infra.services.controlmode.util.LabelHelper;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.papyrus.views.modelexplorer.handler.AbstractModelExplorerHandler;
import org.eclipse.swt.widgets.Display;

public class ControlCommandHandler
extends AbstractModelExplorerHandler {
    public static final String CONTROLMODE_USE_DIALOG_PARAMETER = "org.eclipse.papyrus.infra.services.controlmode.useDialogParameter";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        List selection = this.getCurrentSelectionAdaptedToType(event, EObject.class);
        if (selection == null || selection.isEmpty() || selection.size() > 1) {
            NotificationBuilder.createInfoPopup((String)"Nothing to control").run();
            return null;
        }
        EObject eObjectToControl = (EObject)selection.get(0);
        if (this.getShowDialogParameterValue(event).booleanValue()) {
            IControlModeFragmentDialogProvider provider = this.getDialogProvider(eObjectToControl);
            Dialog dialog = provider.createDialog(Display.getCurrent().getActiveShell(), eObjectToControl.eResource(), this.getDefaultLabelResource(eObjectToControl));
            if (dialog.open() == 0) {
                ControlModeRequest controlRequest = ControlModeRequest.createUIControlModelRequest(this.getEditingDomain(), eObjectToControl, provider.getSelectedURI(dialog));
                IControlModeManager controlMng = ControlModeManager.getInstance();
                ICommand controlCommand = controlMng.getControlCommand(controlRequest);
                this.getEditingDomain().getCommandStack().execute((org.eclipse.emf.common.command.Command)new GMFtoEMFCommandWrapper(controlCommand));
            }
        } else {
            URI defaultURI = this.computeDefaultURI(eObjectToControl.eResource(), this.getDefaultLabelResource(eObjectToControl));
            ControlModeRequest controlRequest = ControlModeRequest.createUIControlModelRequest(this.getEditingDomain(), eObjectToControl, defaultURI);
            IControlModeManager controlMng = ControlModeManager.getInstance();
            ICommand controlCommand = controlMng.getControlCommand(controlRequest);
            this.getEditingDomain().getCommandStack().execute((org.eclipse.emf.common.command.Command)new GMFtoEMFCommandWrapper(controlCommand));
        }
        return null;
    }

    public URI computeDefaultURI(Resource currentResource, String defaultName) {
        String ext = currentResource.getURI().fileExtension();
        URI uri = currentResource.getURI().trimSegments(1);
        uri = uri.appendSegment(defaultName).appendFileExtension(ext);
        return uri;
    }

    protected Boolean getShowDialogParameterValue(ExecutionEvent event) {
        Boolean showDialogValue = null;
        ControlModeCommandParameterValues parameterValues = null;
        try {
            Command command = event.getCommand();
            parameterValues = (ControlModeCommandParameterValues)command.getParameter(CONTROLMODE_USE_DIALOG_PARAMETER).getValues();
            showDialogValue = parameterValues.get("showDialog");
            if (showDialogValue == null) {
                showDialogValue = true;
            }
        }
        catch (ParameterValuesException e) {
            ControlModePlugin.log.error("Parameter values exception in control mode command.", (Throwable)e);
        }
        catch (NotDefinedException e) {
            ControlModePlugin.log.error("Parameter not defined for control mode command.", (Throwable)e);
        }
        return showDialogValue;
    }

    IControlModeFragmentDialogProvider getDialogProvider(EObject context) {
        try {
            ModelSet modelSet = ServiceUtilsForEObject.getInstance().getModelSet((Object)context);
            return (IControlModeFragmentDialogProvider)AdapterUtils.adapt((Object)modelSet, IControlModeFragmentDialogProvider.class, (Object)IControlModeFragmentDialogProvider.DEFAULT);
        }
        catch (ServiceException e) {
            ControlModePlugin.log.error("Cannot obtain ModelSet for controlled object.", (Throwable)e);
            return IControlModeFragmentDialogProvider.DEFAULT;
        }
    }

    protected String getDefaultLabelResource(EObject eObject) {
        Object eGet;
        String defaultName = null;
        EStructuralFeature feature = eObject.eClass().getEStructuralFeature("name");
        if (feature != null && (eGet = eObject.eGet(feature)) instanceof String) {
            defaultName = (String)eGet;
        }
        if (defaultName == null) {
            defaultName = LabelHelper.getPrettyLabel(eObject);
            Pattern p = Pattern.compile("<<.*?>>|<.*?>");
            defaultName = p.matcher(defaultName).replaceAll("").trim();
        }
        StringBuilder b = new StringBuilder();
        char[] cArray = defaultName.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            Character c = Character.valueOf(cArray[n2]);
            if (Character.isJavaIdentifierPart(c.charValue())) {
                b.append(c);
            } else {
                b.append("_");
            }
            ++n2;
        }
        return b.toString();
    }
}

