/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.commands;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.commands.AbstractControlCommand;

public abstract class AbstractControlResourceCommand
extends AbstractControlCommand {
    protected String newFileExtension;

    public AbstractControlResourceCommand(ControlModeRequest request, String label, List affectedFiles) {
        super(label, affectedFiles, request);
    }

    public AbstractControlResourceCommand(ControlModeRequest request, String newFileExtension, String label, List affectedFiles) {
        this(request, label, affectedFiles);
        this.newFileExtension = newFileExtension;
    }

    public ResourceSet getResourceSet() {
        Resource eResource = this.getRequest().getTargetObject().eResource();
        if (eResource == null) {
            throw new RuntimeException("EObject not link to resource set");
        }
        return eResource.getResourceSet();
    }

    protected String getFileExtension() {
        if (this.newFileExtension == null) {
            return this.getTargetUri().fileExtension();
        }
        return this.newFileExtension;
    }

    public URI getTargetUri() {
        if (this.newFileExtension == null) {
            return this.getRequest().getNewURI();
        }
        return this.getRequest().getNewURI().trimFileExtension().appendFileExtension(this.newFileExtension);
    }

    public URI getSourceUri() {
        if (this.newFileExtension == null) {
            return this.getRequest().getSourceURI();
        }
        return this.getRequest().getSourceURI().trimFileExtension().appendFileExtension(this.newFileExtension);
    }
}

