/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor.provider;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.common.tools.api.resource.FileProvider;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.ui.provider.TreeUIPlugin;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.ui.tools.api.provider.DSemanticTargetBasedLabelProvider;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;
import org.eclipse.sirius.viewpoint.FontFormat;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class DTreeColumnLabelProvider
extends DSemanticTargetBasedLabelProvider {
    public DTreeColumnLabelProvider(AdapterFactory adapterFactoryLabelProvider) {
        super(adapterFactoryLabelProvider);
    }

    public Color getBackground(Object element) {
        RGBValues rgb;
        DTreeItem item;
        Color result = null;
        if (element instanceof DTreeItem && (item = (DTreeItem)element).getOwnedStyle() != null && (rgb = item.getOwnedStyle().getBackgroundColor()) != null) {
            result = VisualBindingManager.getDefault().getColorFromRGBValues(rgb);
        }
        return result;
    }

    public Font getFont(Object element) {
        DTreeItem item;
        if (element instanceof DTreeItem && (item = (DTreeItem)element).getOwnedStyle() != null) {
            int size = item.getOwnedStyle().getLabelSize();
            FontFormat labelFormat = null;
            labelFormat = item.getOwnedStyle().getLabelFormat() != null ? item.getOwnedStyle().getLabelFormat() : FontFormat.NORMAL_LITERAL;
            return VisualBindingManager.getDefault().getFontFromLabelFormatAndSize(labelFormat, size);
        }
        return null;
    }

    public Color getForeground(Object element) {
        RGBValues rgb;
        DTreeItem item;
        if (element instanceof DTreeItem && (item = (DTreeItem)element).getOwnedStyle() != null && item.getOwnedStyle().getLabelColor() != null && (rgb = item.getOwnedStyle().getLabelColor()) != null) {
            return VisualBindingManager.getDefault().getLabelColorFromRGBValues(rgb);
        }
        return null;
    }

    public Image getImage(Object element) {
        DTreeItem item;
        if (element instanceof DTreeItem && (item = (DTreeItem)element).getOwnedStyle() != null && item.getOwnedStyle().isShowIcon()) {
            Image labelImage = null;
            labelImage = StringUtil.isEmpty((String)item.getOwnedStyle().getIconPath()) ? super.getImage(element) : this.getCustomImage((BasicLabelStyle)item.getOwnedStyle());
            return labelImage;
        }
        return null;
    }

    private Image getCustomImage(BasicLabelStyle bls) {
        Image customImage = null;
        if (bls != null && !StringUtil.isEmpty((String)bls.getIconPath())) {
            ImageDescriptor descriptor = null;
            String iconPath = bls.getIconPath();
            File imageFile = FileProvider.getDefault().getFile((IPath)new Path(iconPath));
            if (imageFile != null && imageFile.exists() && imageFile.canRead()) {
                try {
                    descriptor = ImageDescriptor.createFromURL((URL)imageFile.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {}
            }
            if (descriptor == null) {
                SiriusPlugin.getDefault().warning("Icon file \"" + iconPath + "\" not found", null);
                descriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            customImage = TreeUIPlugin.getImage(descriptor);
        }
        return customImage;
    }

    public String getText(Object element) {
        DTreeItem item;
        String result = "";
        if (element instanceof DTreeItem && (item = (DTreeItem)element) != null) {
            result = item.getName();
        }
        return result;
    }
}

