/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.internal.workspace;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CheckoutDialog
extends TitleAreaDialog {
    private Text projectNameText;
    private String projectName;

    public CheckoutDialog(Shell parentShell, String projectName) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x400 | 0x20 | 0x10);
        this.projectName = projectName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Check out");
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Check out");
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Group group2 = new Group(composite, 0);
        group2.setLayout((Layout)new GridLayout(1, false));
        group2.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        group2.setText("Repository");
        this.projectNameText = new Text((Composite)group2, 2048);
        this.projectNameText.setText(this.projectName == null ? "" : this.projectName);
        this.projectNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.projectNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String projectName = CheckoutDialog.this.projectNameText.getText();
                if (!Path.EMPTY.isValidSegment(projectName)) {
                    CheckoutDialog.this.setErrorMessage("Invalid project name.");
                    return;
                }
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (project.exists()) {
                    CheckoutDialog.this.setErrorMessage("Project name exists.");
                    return;
                }
                if (new File(project.getLocation().toString()).exists()) {
                    CheckoutDialog.this.setErrorMessage("Project location exists.");
                    return;
                }
                CheckoutDialog.this.setErrorMessage(null);
            }
        });
        return composite;
    }

    protected IManagedContainer getContainer() {
        return IPluginContainer.INSTANCE;
    }

    protected void okPressed() {
        this.projectName = this.projectNameText.getText();
        super.okPressed();
    }
}

