/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.project.builder;

import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFile;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFolder;
import org.eclipse.m2m.internal.qvt.oml.common.io.eclipse.EclipseFile;
import org.eclipse.m2m.internal.qvt.oml.common.io.eclipse.EclipseFileUtil;
import org.eclipse.m2m.internal.qvt.oml.compiler.IImportResolver;
import org.eclipse.m2m.internal.qvt.oml.emf.util.Logger;
import org.eclipse.m2m.internal.qvt.oml.emf.util.WorkspaceUtils;
import org.eclipse.m2m.internal.qvt.oml.project.builder.QVTOBuilderConfig;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.DeployedImportResolver;

public class EclipseImportResolver
implements IImportResolver {
    private DeployedImportResolver deployedQvtFileResolver;
    private SourceContainerProvider sourceProvider;

    public EclipseImportResolver(SourceContainerProvider sourceContainerProvider) {
        this.sourceProvider = sourceContainerProvider;
        this.deployedQvtFileResolver = DeployedImportResolver.INSTANCE;
    }

    public EclipseImportResolver(final IProject project) {
        this(new SourceContainerProvider(){

            public IContainer[] getContainers() {
                return EclipseImportResolver.getSourceContainers(project);
            }
        });
    }

    public EclipseImportResolver(final IContainer[] rootContainers) {
        this(new SourceContainerProvider(){

            public IContainer[] getContainers() {
                return rootContainers;
            }
        });
    }

    public CFile resolveImport(String importedUnitName) {
        String path = importedUnitName.replace('.', '/');
        path = String.valueOf(path) + ".qvto";
        IContainer[] roots = this.sourceProvider.getContainers();
        int i = 0;
        while (i < roots.length) {
            IContainer root = roots[i];
            IPath fullPath = root.getFullPath().append((IPath)new Path(path));
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(fullPath);
            if (file.exists()) {
                return new EclipseFile(file);
            }
            ++i;
        }
        return this.deployedQvtFileResolver.resolveImport(importedUnitName);
    }

    public CFile resolveImport(CFile parentFile, String importedUnitName) {
        return this.resolveImport(importedUnitName);
    }

    public String getPackageName(CFolder folder) {
        String deployedPckgName;
        IContainer container = WorkspaceUtils.getIContainer((String)folder.getFullPath());
        if (!(container != null && container.exists() || (deployedPckgName = this.deployedQvtFileResolver.getPackageName(folder)) == null)) {
            return deployedPckgName;
        }
        IContainer root = this.getBestMatchingRoot(container);
        if (root == null) {
            throw new IllegalArgumentException("Folder " + folder + " is not under source path " + Arrays.asList(this.sourceProvider));
        }
        IPath relPath = EclipseFileUtil.makeRelative((IPath)new Path(folder.getFullPath()), (IPath)new Path(root.getLocation().toOSString()));
        String packName = relPath.toOSString().replaceAll("[/\\\\]", ".");
        return packName;
    }

    private IContainer getBestMatchingRoot(IContainer container) {
        IPath path = container.getFullPath();
        IContainer bestRoot = null;
        IContainer[] roots = this.sourceProvider.getContainers();
        int bestCount = 0;
        int i = 0;
        while (i < roots.length) {
            int count;
            IContainer root = roots[i];
            IPath rootPath = root.getFullPath();
            if ((path.getDevice() == null || path.getDevice().equalsIgnoreCase(rootPath.getDevice())) && (count = rootPath.matchingFirstSegments(path)) > bestCount) {
                count = bestCount;
                bestRoot = root;
            }
            ++i;
        }
        return bestRoot;
    }

    private static IContainer[] getSourceContainers(IProject project) {
        try {
            QVTOBuilderConfig config = QVTOBuilderConfig.getConfig(project);
            return config.getQvtContainers();
        }
        catch (CoreException e) {
            Logger.getLogger().log(Logger.SEVERE, "Failed to get QVT containers for " + project, e);
            return new IContainer[]{project};
        }
    }

    public static interface SourceContainerProvider {
        public IContainer[] getContainers();
    }
}

