/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.uml.profile.Activator;
import org.eclipse.papyrus.uml.profile.Message;
import org.eclipse.papyrus.uml.profile.definition.PapyrusDefinitionAnnotation;
import org.eclipse.papyrus.uml.profile.definition.Version;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.TemplateableElement;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static String getLabel(Object object, boolean shortLabel) {
        String label = "";
        if (object == null) {
            return "undefined";
        }
        if (object instanceof ValueSpecification) {
            label = Util.getLabel((ValueSpecification)object);
        } else if (object instanceof Element) {
            Element cE = (Element)object;
            String cName = null;
            String suffix = "";
            String cComLabel = "";
            NamedElement cNE = null;
            if (object instanceof NamedElement) {
                cNE = (NamedElement)object;
            } else if (object instanceof PackageImport) {
                PackageImport cPI = (PackageImport)object;
                suffix = " (PackageImport)";
                cNE = cPI.getImportedPackage();
            } else if (object instanceof ElementImport) {
                ElementImport cEI = (ElementImport)object;
                suffix = " (ElementImport)";
                cNE = cEI.getImportedElement();
            } else if (object instanceof ProfileApplication) {
                ProfileApplication cPA = (ProfileApplication)object;
                suffix = " (ProfileApplication)";
                cNE = cPA.getAppliedProfile();
            } else if (object instanceof Comment) {
                Comment cCom = (Comment)object;
                suffix = " (Comment)";
                String cComBody = cCom.getBody();
                cComLabel = cComBody != null && cComBody.length() >= 10 ? String.valueOf(cComBody.substring(0, 9)) + "..." : cComBody;
            } else if (object instanceof TemplateSignature) {
                TemplateableElement te = ((TemplateSignature)object).getTemplate();
                suffix = " (TemplateSignature owner)";
                if (te instanceof NamedElement) {
                    cNE = (NamedElement)te;
                }
            } else if (object instanceof TemplateBinding) {
                TemplateableElement te = ((TemplateBinding)object).getBoundElement();
                suffix = " (TemplateBinding bound-element)";
                if (te instanceof NamedElement) {
                    cNE = (NamedElement)te;
                }
            }
            if (shortLabel) {
                if (object instanceof Comment) {
                    cName = cComLabel;
                } else if (cNE != null) {
                    cName = cNE.getName();
                }
            } else if (object instanceof Comment) {
                cName = String.valueOf(cComLabel) + suffix;
            } else if (cNE != null) {
                cName = String.valueOf(cNE.getQualifiedName()) + suffix;
            }
            label = cName != null ? cName : cE.toString();
        }
        return label;
    }

    public static boolean isMetaclass(Type type) {
        Stereotype firstStereotype;
        boolean isMetaclass = false;
        if (type instanceof Class && type.getAppliedStereotypes() != null && type.getAppliedStereotypes().size() > 0 && (firstStereotype = (Stereotype)type.getAppliedStereotypes().get(0)).getName().equals("Metaclass")) {
            isMetaclass = true;
        }
        return isMetaclass;
    }

    public static boolean isMetaclass(EClassifier type) {
        return type.getEPackage() == UMLPackage.eINSTANCE;
    }

    public static String[] getStringArrayFromList(List<Element> elements) {
        ArrayList<String> tmp = new ArrayList<String>();
        if (elements.size() == 0) {
            return null;
        }
        for (Element current : elements) {
            String label = Util.getLabel(current, false);
            tmp.add(label);
        }
        if (tmp.size() == 0) {
            return null;
        }
        String[] elementsNames = new String[tmp.size()];
        int i = 0;
        while (i < tmp.size()) {
            elementsNames[i] = (String)tmp.get(i);
            ++i;
        }
        if (elementsNames.length != elements.size()) {
            Message.error("Number of elements in name list does not match number or elements.");
            elementsNames = null;
        }
        return elementsNames;
    }

    public static Object getValueObjectFromString(String dialogValue, Type type) {
        Object newValue = null;
        String typeName = type.getQualifiedName();
        try {
            Enumeration enumeration;
            EnumerationLiteral literal;
            if (type instanceof PrimitiveType || type instanceof DataType && !(type instanceof Enumeration)) {
                if (typeName.equals("UMLPrimitiveTypes::Integer")) {
                    newValue = Integer.valueOf(dialogValue);
                } else if (typeName.equals("UMLPrimitiveTypes::UnlimitedNatural")) {
                    if (Integer.signum(Integer.parseInt(dialogValue)) != -1) {
                        newValue = Integer.valueOf(dialogValue);
                    } else {
                        Message.warning("UnlimitedNatural must be positive or null.");
                    }
                } else {
                    newValue = typeName.equals("UMLPrimitiveTypes::String") ? dialogValue : (typeName.equals("UMLPrimitiveTypes::Boolean") ? Boolean.valueOf(dialogValue) : dialogValue);
                }
            } else if (type instanceof Enumeration && (literal = (enumeration = (Enumeration)type).getOwnedLiteral(dialogValue)) != null) {
                newValue = literal;
            }
        }
        catch (NumberFormatException e) {
            Message.warning("Bad format number.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newValue;
    }

    private static void checkAndAddElement(EObject currentEObj, java.lang.Class metaType, Stereotype appliedStereotype, ArrayList<Element> filteredElements) {
        block3: {
            Element piCurrentElt;
            block5: {
                block4: {
                    if (!(currentEObj instanceof Element)) break block3;
                    piCurrentElt = (Element)currentEObj;
                    if (appliedStereotype == null) break block4;
                    if (piCurrentElt.getAppliedSubstereotype(appliedStereotype, null) != null) {
                        filteredElements.add(piCurrentElt);
                    }
                    for (Stereotype currentSt : piCurrentElt.getAppliedStereotypes()) {
                        if (!currentSt.conformsTo((Type)appliedStereotype)) continue;
                        filteredElements.add(piCurrentElt);
                    }
                    break block3;
                }
                if (!metaType.isInstance(piCurrentElt)) break block5;
                filteredElements.add(piCurrentElt);
                break block3;
            }
            if (!(piCurrentElt instanceof ElementImport)) break block3;
            TreeIterator eIter = ((ElementImport)piCurrentElt).getImportedElement().eAllContents();
            while (eIter.hasNext()) {
                EObject currentEIelt = (EObject)eIter.next();
                if (!(currentEIelt instanceof Element) || !metaType.isInstance(currentEIelt)) continue;
                filteredElements.add((Element)currentEIelt);
            }
        }
    }

    public static ArrayList<Element> getInstancesFilteredByType(Element element, java.lang.Class metaType, Stereotype appliedStereotype) {
        Package topPackage = Util.topPackage(element);
        Assert.isNotNull((Object)topPackage, (String)("Top package should not be null for element " + element));
        TreeIterator iter = topPackage.eAllContents();
        ArrayList<Element> filteredElements = new ArrayList<Element>();
        while (iter.hasNext()) {
            Package importedPkg;
            EObject currentEObj = (EObject)iter.next();
            if (currentEObj instanceof ElementImport) {
                ElementImport elementImport = (ElementImport)currentEObj;
                currentEObj = elementImport.getImportedElement();
            } else if (currentEObj instanceof PackageImport && (importedPkg = ((PackageImport)currentEObj).getImportedPackage()) != null) {
                TreeIterator piIter = importedPkg.eAllContents();
                while (piIter.hasNext()) {
                    EObject piCurrentEObj = (EObject)piIter.next();
                    Util.checkAndAddElement(piCurrentEObj, metaType, appliedStereotype, filteredElements);
                }
            }
            Util.checkAndAddElement(currentEObj, metaType, appliedStereotype, filteredElements);
        }
        return filteredElements;
    }

    public static void reorderStereotypeApplications(Element element, EList<Stereotype> stereotypes) {
        Iterator s = stereotypes.iterator();
        while (s.hasNext()) {
            EObject stereotypeApplication = element.getStereotypeApplication((Stereotype)s.next());
            if (stereotypeApplication == null) continue;
            UMLUtil.setBaseElement((EObject)stereotypeApplication, null);
            UMLUtil.setBaseElement((EObject)stereotypeApplication, (Element)element);
            Resource eResource = stereotypeApplication.eResource();
            if (eResource == null) continue;
            EList contents = eResource.getContents();
            contents.move(contents.size() - 1, (Object)stereotypeApplication);
        }
    }

    public static String getLabel(ValueSpecification value) {
        String label = "";
        label = value instanceof LiteralBoolean ? "<LiteralBoolean> " : (value instanceof LiteralInteger ? "<LiteralInteger> " : (value instanceof LiteralString ? "<LiteralString> " : (value instanceof LiteralUnlimitedNatural ? "<LiteralUnlimitedNatural> " : "<ValueSpecification> ")));
        label = String.valueOf(label) + value.stringValue();
        return label;
    }

    public static String getOriginLabel(ValueSpecification value) {
        String label = Util.getLabel(value);
        Element owner = value.getOwner();
        if (owner instanceof NamedElement) {
            NamedElement ownerNE = (NamedElement)value.getOwner();
            if (ownerNE.isSetName()) {
                label = String.valueOf(label) + " (" + ownerNE.getQualifiedName() + ")";
            }
        } else if (owner instanceof Slot) {
            Slot ownerSlot = (Slot)owner;
            InstanceSpecification ownerISpec = ownerSlot.getOwningInstance();
            StructuralFeature definingFeature = ownerSlot.getDefiningFeature();
            label = String.valueOf(label) + " (" + ownerISpec.getQualifiedName() + "::" + definingFeature.getLabel() + ")";
        }
        return label;
    }

    public static Package topPackage(Element element) {
        if (element.getOwner() == null) {
            return (Package)element;
        }
        return Util.topPackage(element.getOwner());
    }

    public static List<PapyrusDefinitionAnnotation> getAllPapyrusDefinitionAnnotation(Profile profile) {
        ArrayList<PapyrusDefinitionAnnotation> definitions = new ArrayList<PapyrusDefinitionAnnotation>();
        Iterator<EAnnotation> it = Util.getAllPapyrusVersionAnnotation(profile).iterator();
        while (it.hasNext()) {
            definitions.add(PapyrusDefinitionAnnotation.parseEAnnotation(it.next()));
        }
        return definitions;
    }

    public static List<EAnnotation> getAllPapyrusVersionAnnotation(Profile profile) {
        ArrayList<EAnnotation> annotations = new ArrayList<EAnnotation>();
        EAnnotation definitions = profile.getEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML");
        if (definitions == null) {
            return annotations;
        }
        for (EPackage object : definitions.getContents()) {
            EAnnotation annotation = object.getEAnnotation("PapyrusVersion");
            if (annotation == null) continue;
            annotations.add(annotation);
        }
        return annotations;
    }

    public static EAnnotation getPapyrusVersionAnnotation(Profile profile) {
        if (profile.getDefinition() != null) {
            return profile.getDefinition().getEAnnotation("PapyrusVersion");
        }
        return null;
    }

    public static Version getProfileDefinitionVersion(Profile profile) {
        return Util.getDefinitionVersion(profile.getDefinition());
    }

    public static String getProfileDefinitionAuthor(Profile profile) {
        EAnnotation annotation = Util.getPapyrusVersionAnnotation(profile);
        if (annotation == null) {
            return "";
        }
        String value = (String)annotation.getDetails().get((Object)"Author");
        return value != null ? value : "";
    }

    public static String getProfileDefinitionDate(Profile profile) {
        EAnnotation annotation = Util.getPapyrusVersionAnnotation(profile);
        if (annotation == null) {
            return "";
        }
        String value = (String)annotation.getDetails().get((Object)"Date");
        return value != null ? value : "";
    }

    public static String getProfileDefinitionComment(Profile profile) {
        EAnnotation annotation = Util.getPapyrusVersionAnnotation(profile);
        if (annotation == null) {
            return "";
        }
        String value = (String)annotation.getDetails().get((Object)"Comment");
        return value != null ? value : "";
    }

    public static String getProfileDefinitionCopyright(Profile profile) {
        EAnnotation annotation = Util.getPapyrusVersionAnnotation(profile);
        if (annotation == null) {
            return "";
        }
        String value = (String)annotation.getDetails().get((Object)"Copyright");
        return value != null ? value : "";
    }

    public static ProfileApplication getNearestProfileApplicationFor(Element element, Stereotype stereotype) {
        ProfileApplication profileApplication = null;
        Profile profile = stereotype.getProfile();
        Element container = element;
        while (profileApplication == null && container != null) {
            if (container instanceof Package) {
                profileApplication = ((Package)container).getProfileApplication(profile);
            }
            container = container.eContainer();
        }
        return profileApplication;
    }

    public static Version getDefinitionVersion(EPackage definition) {
        Version version;
        if (definition == null) {
            return Version.emptyVersion;
        }
        EAnnotation annotation = definition.getEAnnotation("PapyrusVersion");
        if (annotation == null) {
            return Version.emptyVersion;
        }
        String value = "";
        try {
            value = (String)annotation.getDetails().get((Object)"Version");
            version = new Version(value != null ? value : "");
        }
        catch (Exception e) {
            Activator.logWarning("impossible to parse the version value: " + value);
            version = Version.emptyVersion;
        }
        return version;
    }
}

