/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.ui.items;

import java.util.List;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.papyrus.uml.profile.Message;
import org.eclipse.papyrus.uml.profile.utils.Util;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Property;

public class EnumerationItems {
    public EnumerationItems(Table table, Property property, Object value) {
        if (property.isMultivalued()) {
            List propValues = (List)value;
            int i = 0;
            while (i < propValues.size()) {
                this.createItem(table, property, propValues.get(i));
                ++i;
            }
        } else if (value != null) {
            this.createItem(table, property, value);
        }
    }

    private void createItem(Table table, Property property, Object object) {
        EnumerationLiteral eLiteral = null;
        if (object instanceof EnumerationLiteral) {
            eLiteral = (EnumerationLiteral)object;
        } else if (object instanceof EEnumLiteral) {
            EEnumLiteral eEnumLiteral = (EEnumLiteral)object;
            Object tmp = Util.getValueObjectFromString(eEnumLiteral.getName(), property.getType());
            eLiteral = (EnumerationLiteral)tmp;
        } else if (object instanceof String) {
            String literalString = (String)object;
            Object tmp = Util.getValueObjectFromString(literalString, property.getType());
            eLiteral = (EnumerationLiteral)tmp;
        } else {
            String err = "Value " + object.toString() + " of Property " + property.getName() + " is not an EnumerationLiteral.";
            Message.error(err);
        }
        if (eLiteral != null) {
            TableItem propValueItem = new TableItem(table, 0);
            propValueItem.setText(eLiteral.getName());
            propValueItem.setData((Object)eLiteral);
        }
    }
}

