/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.uicore.internal.model;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.AppearanceConfiguration;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.model.ITreeElement;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.model.ModelElementItem;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.util.ImageProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIAttribute
implements ITreeElement {
    private final EObject element;
    private final ITreeElement treeParent;
    private final AppearanceConfiguration appearanceConfiguration;

    public URIAttribute(EObject element, ITreeElement treeParent, AppearanceConfiguration appearanceConfiguration) {
        this.element = element;
        this.treeParent = treeParent;
        this.appearanceConfiguration = appearanceConfiguration;
    }

    @Override
    public String getText() {
        URI uri = EcoreUtil.getURI((EObject)this.element);
        String uriStr = uri != null ? uri.toString() : "null";
        return "/URI = " + uriStr;
    }

    @Override
    public Image getImage() {
        return ImageProvider.getInstance().getAttributeIcon();
    }

    public Object getParent() {
        return this.element;
    }

    @Override
    public ITreeElement getTreeParent() {
        return this.treeParent;
    }

    public List<ModelElementItem> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public Font getFont() {
        return this.appearanceConfiguration.getCustomItalicFont();
    }

    @Override
    public Color getForeground() {
        return null;
    }

    @Override
    public Color getBackground() {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof URIAttribute) {
            URIAttribute other = (URIAttribute)obj;
            return this.element.equals(other.element);
        }
        return false;
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public String toString() {
        return String.valueOf(URIAttribute.class.getSimpleName()) + "(" + this.getText() + ")";
    }
}

