/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.readonly.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.workspace.WorkspaceEditingDomainFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.resource.ReadOnlyAxis;
import org.eclipse.papyrus.infra.emf.readonly.ReadOnlyManager;
import org.eclipse.papyrus.infra.emf.utils.BusinessModelResolver;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.onefile.model.IPapyrusFile;
import org.eclipse.papyrus.infra.onefile.model.PapyrusModelHelper;
import org.eclipse.papyrus.infra.onefile.utils.OneFileUtils;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class EnableWriteCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        EObject elem = this.getSelectedElement();
        if (elem != null && elem.eResource() != null && elem.eResource().getResourceSet() != null) {
            Resource res = elem.eResource();
            ResourceSet rs = res.getResourceSet();
            if (res.getURI() != null && res.getURI().isPlatformResource()) {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(res.getURI().toPlatformString(true)));
                IPapyrusFile papFile = PapyrusModelHelper.getPapyrusModelFactory().createIPapyrusFile(file);
                IFile[] associatedFiles = OneFileUtils.getAssociatedFiles((IPapyrusFile)papFile);
                URI[] associatedUris = new URI[associatedFiles.length];
                int i = 0;
                while (i < associatedFiles.length) {
                    associatedUris[i] = URI.createPlatformResourceURI((String)associatedFiles[i].getFullPath().toString(), (boolean)true);
                    ++i;
                }
                ReadOnlyManager.getReadOnlyHandler((EditingDomain)WorkspaceEditingDomainFactory.INSTANCE.getEditingDomain(rs)).makeWritable(ReadOnlyAxis.anyAxis(), associatedUris);
            }
        }
        return null;
    }

    protected EObject getSelectedElement() {
        ISelection selection;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && (selection = activeWorkbenchWindow.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            return this.resolveSemanticObject(obj);
        }
        return null;
    }

    protected EObject resolveSemanticObject(Object object) {
        Object businessObject = BusinessModelResolver.getInstance().getBusinessModel(object);
        if (businessObject instanceof EObject) {
            return (EObject)businessObject;
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        EObject selected = this.getSelectedElement();
        EditingDomain domain = selected == null ? null : EMFHelper.resolveEditingDomain((EObject)selected);
        this.setBaseEnabled(domain != null && EMFHelper.canMakeWritable((EObject)selected, (EditingDomain)domain));
    }
}

