/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.readonly;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomainEvent;
import org.eclipse.emf.transaction.TransactionalEditingDomainListener;
import org.eclipse.emf.transaction.util.TransactionUtil;

class ControlledResourceTracker
extends AdapterImpl
implements TransactionalEditingDomainListener {
    private Map<URI, URI> unitMap = new HashMap<URI, URI>();
    private Map<URI, URI> pending;

    static ControlledResourceTracker getInstance(EditingDomain domain) {
        ControlledResourceTracker result = null;
        for (Object next : domain.getResourceSet().eAdapters()) {
            if (!(next instanceof ControlledResourceTracker)) continue;
            result = (ControlledResourceTracker)((Object)next);
            break;
        }
        if (result == null) {
            result = new ControlledResourceTracker(domain);
        }
        return result;
    }

    private ControlledResourceTracker(EditingDomain domain) {
        domain.getResourceSet().eAdapters().add((Object)this);
        if (domain instanceof TransactionalEditingDomain) {
            ((TransactionalEditingDomain.Lifecycle)TransactionUtil.getAdapter((TransactionalEditingDomain)((TransactionalEditingDomain)domain), TransactionalEditingDomain.Lifecycle.class)).addTransactionalEditingDomainListener((TransactionalEditingDomainListener)this);
        }
        this.commit();
    }

    URI getRootResourceURI(URI uri) {
        URI result = uri.trimFileExtension();
        URI parent = this.get(result);
        while (parent != null) {
            if (parent != null) {
                result = parent;
            }
            parent = this.get(parent);
        }
        return uri.fileExtension() == null ? result : result.appendFileExtension(uri.fileExtension());
    }

    private URI get(URI potentialUnit) {
        URI result = this.unitMap.get(potentialUnit);
        if (result == null && this.pending != null) {
            result = this.pending.get(potentialUnit);
        }
        return result;
    }

    private void ensurePending() {
        if (this.pending == null) {
            this.pending = new HashMap<URI, URI>(this.unitMap);
        }
    }

    private void map(URI controlledUnit, URI parentUnit) {
        this.ensurePending();
        this.pending.put(controlledUnit.trimFileExtension(), parentUnit.trimFileExtension());
    }

    private void unmap(URI controlledUnit) {
        this.ensurePending();
        this.pending.remove(controlledUnit.trimFileExtension());
    }

    private void commit() {
        if (this.pending != null) {
            this.unitMap = this.pending;
            this.pending = null;
        }
    }

    private void rollback() {
        this.pending = null;
    }

    public void setTarget(Notifier newTarget) {
        if (newTarget instanceof ResourceSet) {
            for (Resource next : ((ResourceSet)newTarget).getResources()) {
                this.addAdapter((Notifier)next);
            }
        } else if (newTarget instanceof Resource) {
            this.handleResource((Resource)newTarget);
        }
    }

    protected void addAdapter(Notifier notifier) {
        notifier.eAdapters().add((Object)this);
    }

    protected void removeAdapter(Notifier notifier) {
        notifier.eAdapters().remove((Object)this);
    }

    public void unsetTarget(Notifier oldTarget) {
        if (oldTarget instanceof ResourceSet) {
            for (Resource next : ((ResourceSet)oldTarget).getResources()) {
                this.removeAdapter((Notifier)next);
            }
        }
    }

    protected void handleResource(Resource resource) {
        EObject root;
        InternalEObject container;
        if (!resource.getContents().isEmpty() && (container = ((InternalEObject)(root = (EObject)resource.getContents().get(0))).eInternalContainer()) != null) {
            URI parentURI;
            URI uRI = parentURI = container.eIsProxy() ? container.eProxyURI().trimFragment() : container.eResource().getURI();
            if (parentURI != null) {
                this.map(resource.getURI(), parentURI);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void notifyChanged(Notification msg) {
        Object notifier = msg.getNotifier();
        if (notifier instanceof ResourceSet) {
            switch (msg.getFeatureID(ResourceSet.class)) {
                case 0: {
                    switch (msg.getEventType()) {
                        case 3: {
                            this.addAdapter((Notifier)((Resource)msg.getNewValue()));
                            return;
                        }
                        case 5: {
                            Iterator iterator = ((Collection)msg.getNewValue()).iterator();
                            while (true) {
                                if (!iterator.hasNext()) {
                                    return;
                                }
                                Object next = iterator.next();
                                this.addAdapter((Notifier)((Resource)next));
                            }
                        }
                        case 1: {
                            this.removeAdapter((Notifier)((Resource)msg.getOldValue()));
                            this.addAdapter((Notifier)((Resource)msg.getNewValue()));
                            return;
                        }
                        case 4: {
                            this.removeAdapter((Notifier)((Resource)msg.getOldValue()));
                            return;
                        }
                        case 6: {
                            for (Object next : (Collection)msg.getOldValue()) {
                                this.removeAdapter((Notifier)((Resource)next));
                            }
                        }
                    }
                }
            }
            return;
        }
        if (!(notifier instanceof Resource)) return;
        switch (msg.getFeatureID(Resource.class)) {
            case 2: {
                switch (msg.getEventType()) {
                    case 3: 
                    case 5: {
                        if (msg.getPosition() != 0) return;
                        this.handleResource((Resource)notifier);
                        return;
                    }
                    case 1: {
                        if (msg.getPosition() != 0) return;
                        Resource resource = (Resource)notifier;
                        this.unmap(resource.getURI());
                        this.handleResource(resource);
                        return;
                    }
                    case 4: 
                    case 6: {
                        if (msg.getPosition() != 0) return;
                        this.unmap(((Resource)msg.getNotifier()).getURI());
                    }
                }
                return;
            }
        }
    }

    public void transactionClosed(TransactionalEditingDomainEvent event) {
        if (event.getTransaction().getStatus().getSeverity() >= 4) {
            this.rollback();
        } else {
            this.commit();
        }
    }

    public void editingDomainDisposing(TransactionalEditingDomainEvent event) {
        this.removeAdapter((Notifier)event.getSource().getResourceSet());
    }

    public void transactionStarting(TransactionalEditingDomainEvent event) {
    }

    public void transactionInterrupted(TransactionalEditingDomainEvent event) {
    }

    public void transactionStarted(TransactionalEditingDomainEvent event) {
    }

    public void transactionClosing(TransactionalEditingDomainEvent event) {
    }
}

