/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ui.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.m2m.internal.qvt.oml.ui.QVTUIPlugin;
import org.eclipse.m2m.internal.qvt.oml.ui.QvtPluginImages;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.AbstractNewQVTElementWizard;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.Messages;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.NewQvtModuleCreationPage;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.INewQVTElementDestinationWizardDelegate;

public class NewQvtLibraryWizard
extends AbstractNewQVTElementWizard {
    private NewQvtModuleCreationPage fNewQvtModuleCreationPage;

    public NewQvtLibraryWizard() {
        this.setWindowTitle(Messages.NewQVTLibraryWizard_Title);
        ImageDescriptor desc = QvtPluginImages.getInstance().getImageDescriptor("new_wizard");
        this.setDefaultPageImageDescriptor(desc);
    }

    protected NewQvtModuleCreationPage createNewQvtLibraryCreationPage() {
        if (this.getDestinationProvider() != null) {
            return new NewQvtLibraryPage(this.getDestinationProvider());
        }
        return new NewQvtLibraryPage();
    }

    protected final NewQvtModuleCreationPage getNewQvtLibraryCreationPage() {
        return this.fNewQvtModuleCreationPage;
    }

    protected String createModuleContents() {
        String moduleName = this.fNewQvtModuleCreationPage.getModuleName();
        String contents = "library " + moduleName + ";\n";
        return contents.toString();
    }

    protected void doAddPages() {
        this.fNewQvtModuleCreationPage = this.createNewQvtLibraryCreationPage();
        this.fNewQvtModuleCreationPage.setTitle(Messages.NewQvtLibraryWizard_NewModulePageTitle);
        this.fNewQvtModuleCreationPage.setDescription(Messages.NewQvtLibraryWizard_NewModulePageDescription);
        this.addPage((IWizardPage)this.fNewQvtModuleCreationPage);
        this.setContentsCreated(true);
    }

    public boolean doPerformFinish(IProgressMonitor monitor) {
        try {
            IFile transformationFile = this.fNewQvtModuleCreationPage.createNewFile(this.createModuleContents(), monitor);
            NewQvtModuleCreationPage.openInEditor(this.getShell(), transformationFile);
            return true;
        }
        catch (Exception exception) {
            QVTUIPlugin.log(exception);
            return false;
        }
    }

    public boolean canFinish() {
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            if (!pages[i].isPageComplete()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void addPages() {
        this.doAddPages();
    }

    private static final class NewQvtLibraryPage
    extends NewQvtModuleCreationPage {
        NewQvtLibraryPage() {
        }

        NewQvtLibraryPage(INewQVTElementDestinationWizardDelegate destinationProvider) {
            super(destinationProvider);
        }

        protected String getNewModuleNameProposal() {
            return Messages.NewQvtLibraryWizard_newLibraryNameProposal;
        }
    }
}

