/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.databinding;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.internal.databinding.Util;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.appearance.helper.AppliedStereotypeHelper;
import org.eclipse.papyrus.uml.properties.Activator;
import org.eclipse.papyrus.uml.tools.utils.ElementUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class StereotypeAppearanceObservableValue
extends AbstractObservableValue
implements IObserving {
    protected String propertyPath;
    protected Element element;
    protected EModelElement diagramElement;
    protected TransactionalEditingDomain domain;
    private Adapter diagramElementListener;
    private String cachedValue;

    public StereotypeAppearanceObservableValue(EModelElement diagramElement, Element element, String propertyPath, EditingDomain domain) {
        this.propertyPath = propertyPath;
        this.diagramElement = diagramElement;
        this.element = element;
        this.domain = (TransactionalEditingDomain)domain;
        if (diagramElement != null) {
            diagramElement.eAdapters().add((Object)this.getDiagramElementListener());
        }
    }

    private Adapter getDiagramElementListener() {
        if (this.diagramElementListener == null) {
            this.diagramElementListener = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (!msg.isTouch()) {
                        StereotypeAppearanceObservableValue.this.handleStereotypeChanged(msg);
                    }
                }
            };
        }
        return this.diagramElementListener;
    }

    protected void handleStereotypeChanged(Notification msg) {
        this.setValue(this.doGetValue());
    }

    public Object getValueType() {
        return String.class;
    }

    protected String doGetValue() {
        if (this.propertyPath.equals("stereotypeDisplay")) {
            return this.getStereotypeDisplayValue();
        }
        if (this.propertyPath.equals("textAlignment")) {
            return this.getTextAlignmentValue();
        }
        if (this.propertyPath.equals("displayPlace")) {
            return this.getDisplayPlaceValue();
        }
        return null;
    }

    private String getStereotypeDisplayValue() {
        String stereotypePresentation = AppliedStereotypeHelper.getAppliedStereotypePresentationKind((EModelElement)this.diagramElement);
        if (stereotypePresentation != null) {
            Element element = (Element)((View)this.diagramElement).getElement();
            Stereotype stereotype = AppliedStereotypeHelper.getFirstDisplayedStereotype((EModelElement)this.diagramElement, (Element)element);
            boolean hasIcons = ElementUtil.hasIcons((Element)element, (Stereotype)stereotype);
            boolean hasShapes = ElementUtil.hasShapes((Element)element, (Stereotype)stereotype);
            if (stereotypePresentation.equals("IconStereotype") && hasIcons) {
                return "Icon";
            }
            if (stereotypePresentation.equals("TextIconStereotype") && hasIcons) {
                return "Text and Icon";
            }
            if (stereotypePresentation.equals("ImageStereotype") && hasShapes) {
                return "Shape";
            }
            return "Text";
        }
        return "Text";
    }

    private String getTextAlignmentValue() {
        String stereotypePresentation = AppliedStereotypeHelper.getAppliedStereotypePresentationKind((EModelElement)this.diagramElement);
        if (stereotypePresentation != null) {
            if (stereotypePresentation.equals("HorizontalStereo")) {
                return "Horizontal";
            }
            if (stereotypePresentation.equals("VerticalStereo")) {
                return "Vertical";
            }
            return "Horizontal";
        }
        return "Horizontal";
    }

    private String getDisplayPlaceValue() {
        if (this.diagramElement != null) {
            return AppliedStereotypeHelper.getAppliedStereotypesPropertiesLocalization((EModelElement)this.diagramElement);
        }
        return null;
    }

    protected void doSetValue(Object value) {
        if (value instanceof String) {
            String currentValue;
            String oldValue = this.cachedValue;
            String stringValue = (String)value;
            if (this.diagramElement != null) {
                this.diagramElement.eAdapters().remove((Object)this.diagramElementListener);
            }
            if (!Util.equals((Object)(currentValue = this.doGetValue()), (Object)stringValue)) {
                if (this.propertyPath.equals("stereotypeDisplay")) {
                    this.setStereotypeDisplayValue(stringValue);
                } else if (this.propertyPath.equals("textAlignment")) {
                    this.setTextAlignmentValue(stringValue);
                } else if (this.propertyPath.equals("displayPlace")) {
                    this.setDisplayPlaceValue(stringValue);
                }
            }
            if (!Util.equals((Object)oldValue, (Object)stringValue) && this.hasListeners()) {
                this.fireValueChange(Diffs.createValueDiff((Object)oldValue, (Object)stringValue));
            }
            if (this.diagramElement != null) {
                this.diagramElement.eAdapters().add((Object)this.getDiagramElementListener());
            }
            this.cachedValue = stringValue;
        } else {
            Activator.log.warn("The value " + value + " is invalid for property " + this.propertyPath);
        }
    }

    private void setStereotypeDisplayValue(String stereotypeAppearance) {
        Stereotype stereotype = AppliedStereotypeHelper.getFirstDisplayedStereotype((EModelElement)this.diagramElement, (Element)this.element);
        boolean hasIcons = ElementUtil.hasIcons((Element)this.element, (Stereotype)stereotype);
        boolean hasShapes = ElementUtil.hasShapes((Element)this.element, (Stereotype)stereotype);
        String appliedStereotypeKind = "HorizontalStereo";
        if (stereotypeAppearance.equals("Text")) {
            appliedStereotypeKind = "HorizontalStereo";
        } else if (stereotypeAppearance.equals("Icon") && hasIcons) {
            appliedStereotypeKind = "IconStereotype";
        } else if (stereotypeAppearance.equals("Text and Icon") && hasIcons) {
            appliedStereotypeKind = "TextIconStereotype";
        } else if (stereotypeAppearance.equals("Shape") && hasShapes) {
            appliedStereotypeKind = "ImageStereotype";
        }
        String stereotypetoDisplay = AppliedStereotypeHelper.getStereotypesToDisplay((EModelElement)this.diagramElement);
        RecordingCommand command = AppliedStereotypeHelper.getAppliedStereotypeToDisplayCommand((TransactionalEditingDomain)this.domain, (EModelElement)this.diagramElement, (String)stereotypetoDisplay, (String)appliedStereotypeKind);
        this.domain.getCommandStack().execute((Command)command);
    }

    private void setTextAlignmentValue(String alignment) {
        String appliedStereotypeKind = "HorizontalStereo";
        if (alignment.equals("Horizontal")) {
            appliedStereotypeKind = "HorizontalStereo";
        } else if (alignment.equals("Vertical")) {
            appliedStereotypeKind = "VerticalStereo";
        }
        String stereotypetoDisplay = AppliedStereotypeHelper.getStereotypesToDisplay((EModelElement)this.diagramElement);
        RecordingCommand command = AppliedStereotypeHelper.getAppliedStereotypeToDisplayCommand((TransactionalEditingDomain)this.domain, (EModelElement)this.diagramElement, (String)stereotypetoDisplay, (String)appliedStereotypeKind);
        this.domain.getCommandStack().execute((Command)command);
    }

    private void setDisplayPlaceValue(String stereotypePlacePresentation) {
        RecordingCommand command = AppliedStereotypeHelper.getSetAppliedStereotypePropertiesLocalizationCommand((TransactionalEditingDomain)this.domain, (EModelElement)this.diagramElement, (String)stereotypePlacePresentation);
        this.domain.getCommandStack().execute((Command)command);
    }

    public Object getObserved() {
        return this.diagramElement;
    }

    public synchronized void dispose() {
        if (this.diagramElement != null && this.diagramElementListener != null) {
            this.diagramElement.eAdapters().remove((Object)this.diagramElementListener);
        }
        super.dispose();
    }
}

