/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.databinding;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.CustomStringStyleObservableList;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.IMaskManagedLabelEditPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaskValueObservableList
extends CustomStringStyleObservableList {
    private EditPart editPart;

    public MaskValueObservableList(EditPart editPart, EditingDomain domain) {
        super(MaskValueObservableList.getView(editPart), domain, "maskLabel");
        this.editPart = editPart;
        this.updateWrappedList(this.getDefaultValues());
    }

    private static View getView(EditPart editPart) {
        return (View)editPart.getModel();
    }

    protected IObservableList getConcreteList() {
        if (!this.isStyleCreated()) {
            return new WritableList(this.getDefaultValues(), String.class);
        }
        return super.getConcreteList();
    }

    protected List<String> getDefaultValues() {
        return new LinkedList<String>(((IMaskManagedLabelEditPolicy)this.editPart.getEditPolicy((Object)"MaskManagedLabelPolicy")).getCurrentDisplayValue());
    }

    protected void refreshCacheList() {
        super.refreshCacheList();
        ((IMaskManagedLabelEditPolicy)this.editPart.getEditPolicy((Object)"MaskManagedLabelPolicy")).refreshDisplay();
    }

    public Command getRemoveCommand(Object value) {
        if (this.isStyleCreated()) {
            return super.getRemoveCommand(value);
        }
        HashSet currentValues = new HashSet(this.wrappedList);
        if (currentValues.remove(value)) {
            return this.getAddAllCommand(currentValues);
        }
        return UnexecutableCommand.INSTANCE;
    }

    public Command getRemoveAllCommand(Collection<?> values) {
        if (this.isStyleCreated()) {
            return super.getRemoveAllCommand(values);
        }
        HashSet currentValues = new HashSet(this.wrappedList);
        if (currentValues.containsAll(values)) {
            currentValues.removeAll(values);
            if (currentValues.isEmpty()) {
                return IdentityCommand.INSTANCE;
            }
            return this.getAddAllCommand(currentValues);
        }
        return UnexecutableCommand.INSTANCE;
    }
}

