/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.spi.cdo;

import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOChangeSet;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.session.CDOSessionInvalidationEvent;
import org.eclipse.emf.cdo.transaction.CDOCommitContext;
import org.eclipse.emf.cdo.transaction.CDOConflictResolver;
import org.eclipse.emf.cdo.transaction.CDODefaultTransactionHandler;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandler;
import org.eclipse.emf.spi.cdo.AbstractConflictResolver;
import org.eclipse.emf.spi.cdo.CDOChangeSubscriptionAdapter;
import org.eclipse.emf.spi.cdo.CDOSessionInvalidationEventQueue;

public abstract class AbstractChangeSetsConflictResolver
extends AbstractConflictResolver
implements CDOConflictResolver.NonConflictAware {
    private CDOTransactionHandler handler = new CDODefaultTransactionHandler(){

        public void modifyingObject(CDOTransaction transaction, CDOObject object, CDOFeatureDelta ignored) {
            if (AbstractChangeSetsConflictResolver.this.getTransaction() == transaction) {
                AbstractChangeSetsConflictResolver.this.adapter.attach(object);
            }
        }

        public void committedTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
            if (AbstractChangeSetsConflictResolver.this.getTransaction() == transaction) {
                AbstractChangeSetsConflictResolver.this.adapter.reset();
                AbstractChangeSetsConflictResolver.this.remoteInvalidationEvents.reset();
            }
        }

        public void rolledBackTransaction(CDOTransaction transaction) {
            if (AbstractChangeSetsConflictResolver.this.getTransaction() == transaction && transaction.getLastSavepoint().getPreviousSavepoint() == null) {
                AbstractChangeSetsConflictResolver.this.adapter.reset();
                AbstractChangeSetsConflictResolver.this.remoteInvalidationEvents.reset();
            }
        }
    };
    private CDOChangeSubscriptionAdapter adapter;
    private RemoteInvalidationEventQueue remoteInvalidationEvents;

    public CDOChangeSetData getLocalChangeSetData() {
        return this.getTransaction().getChangeSetData();
    }

    public CDOChangeSet getLocalChangeSet() {
        CDOChangeSetData changeSetData = this.getLocalChangeSetData();
        return this.createChangeSet(changeSetData);
    }

    public CDOChangeSetData getRemoteChangeSetData() {
        return this.remoteInvalidationEvents.poll();
    }

    public CDOChangeSet getRemoteChangeSet() {
        CDOChangeSetData changeSetData = this.getRemoteChangeSetData();
        if (changeSetData == null) {
            return null;
        }
        return this.createChangeSet(changeSetData);
    }

    public void handleNonConflict(long updateTime) {
        this.remoteInvalidationEvents.remove(updateTime);
    }

    protected void hookTransaction(CDOTransaction transaction) {
        this.adapter = new CDOChangeSubscriptionAdapter(this.getTransaction());
        this.remoteInvalidationEvents = new RemoteInvalidationEventQueue();
        transaction.addTransactionHandler(this.handler);
    }

    protected void unhookTransaction(CDOTransaction transaction) {
        transaction.removeTransactionHandler(this.handler);
        this.remoteInvalidationEvents.dispose();
        this.remoteInvalidationEvents = null;
        this.adapter.dispose();
        this.adapter = null;
    }

    private CDOChangeSet createChangeSet(CDOChangeSetData changeSetData) {
        CDOTransaction transaction = this.getTransaction();
        return CDORevisionUtil.createChangeSet((CDOBranchPoint)transaction, (CDOBranchPoint)transaction, (CDOChangeSetData)changeSetData);
    }

    private final class RemoteInvalidationEventQueue
    extends CDOSessionInvalidationEventQueue {
        public RemoteInvalidationEventQueue() {
            super(AbstractChangeSetsConflictResolver.this.getTransaction().getSession());
        }

        protected void handleEvent(CDOSessionInvalidationEvent event) throws Exception {
            CDOTransaction transaction = AbstractChangeSetsConflictResolver.this.getTransaction();
            if (event.getLocalTransaction() == transaction) {
                return;
            }
            if (event.getBranch() != transaction.getBranch()) {
                return;
            }
            super.handleEvent(event);
        }
    }
}

