/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.transaction;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOUndoDetector;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.ObjectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOUndoDetectorImpl
implements CDOUndoDetector {
    @Override
    public boolean detectUndo(CDOTransaction transaction, CDORevision cleanRevision, CDORevision revision, CDOFeatureDelta featureDelta) {
        InternalCDORevision revision2;
        InternalCDORevision revision1;
        EStructuralFeature feature = featureDelta.getFeature();
        if (this.ignore(feature, revision1 = (InternalCDORevision)cleanRevision, revision2 = (InternalCDORevision)revision)) {
            return false;
        }
        if (feature == CDOContainerFeatureDelta.CONTAINER_FEATURE) {
            return this.detectUndoContainer(revision1, revision2);
        }
        Object value1 = revision1.getValue(feature);
        Object value2 = revision2.getValue(feature);
        if (feature instanceof EReference) {
            if (feature.isMany()) {
                int size2;
                List list1 = (List)value1;
                List list2 = (List)value2;
                int size1 = CDOUndoDetectorImpl.size(list1);
                if (size1 != (size2 = CDOUndoDetectorImpl.size(list2))) {
                    return false;
                }
                if (size1 != 0) {
                    Iterator it1 = list1.iterator();
                    Iterator it2 = list2.iterator();
                    while (it1.hasNext()) {
                        Object id2;
                        Object id1 = CDOUndoDetectorImpl.getID(it1.next());
                        if (id1 == (id2 = CDOUndoDetectorImpl.getID(it2.next()))) continue;
                        return false;
                    }
                }
                return true;
            }
            return (value1 = CDOUndoDetectorImpl.getID(value1)) == (value2 = CDOUndoDetectorImpl.getID(value2));
        }
        return ObjectUtil.equals((Object)value1, (Object)value2);
    }

    protected boolean detectUndoContainer(InternalCDORevision revision1, InternalCDORevision revision2) {
        Object containerID2;
        int containingFeatureID2;
        CDOID resourceID2;
        CDOID resourceID1 = revision1.getResourceID();
        if (resourceID1 != (resourceID2 = revision2.getResourceID())) {
            return false;
        }
        int containingFeatureID1 = revision1.getContainingFeatureID();
        if (containingFeatureID1 != (containingFeatureID2 = revision2.getContainingFeatureID())) {
            return false;
        }
        Object c1 = revision1.getContainerID();
        Object c2 = revision2.getContainerID();
        Object containerID1 = CDOUndoDetectorImpl.getID(c1);
        return containerID1 == (containerID2 = CDOUndoDetectorImpl.getID(c2));
    }

    protected boolean ignore(EStructuralFeature feature, InternalCDORevision revision1, InternalCDORevision revision2) {
        return feature.isMany() && !revision1.isUnchunked() && !revision2.isUnchunked();
    }

    private static Object getID(Object value) {
        return value;
    }

    private static int size(List<?> list) {
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    public static final class NoFeatures
    implements CDOUndoDetector {
        public boolean detectUndo(CDOTransaction transaction, CDORevision revision1, CDORevision revision2, CDOFeatureDelta featureDelta) {
            return false;
        }
    }

    public static final class SingleValuedFeatures
    extends CDOUndoDetectorImpl {
        protected boolean ignore(EStructuralFeature feature, InternalCDORevision revision1, InternalCDORevision revision2) {
            if (feature.isMany()) {
                return false;
            }
            return super.ignore(feature, revision1, revision2);
        }
    }
}

