/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.transaction;

import org.eclipse.emf.cdo.transaction.CDOCommitContext;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandler2;
import org.eclipse.net4j.util.collection.Closeable;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;

public class CDOTransactionCommentator
implements Closeable {
    private final IListener transactionListener = new LifecycleEventAdapter(){

        protected void onDeactivated(ILifecycle lifecycle) {
            CDOTransactionCommentator.this.close();
        }
    };
    private final CDOTransactionHandler2 transactionHandler = new CDOTransactionHandler2(){
        private String lastComment;

        public void committingTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
            this.lastComment = CDOTransactionCommentator.this.createComment(commitContext);
            if (this.lastComment != null) {
                String commitComment = transaction.getCommitComment();
                if (commitComment != null) {
                    commitComment = " " + this.lastComment;
                    transaction.setCommitComment(commitComment);
                } else {
                    transaction.setCommitComment(this.lastComment);
                }
            }
        }

        public void committedTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
            this.cleanUp();
        }

        public void rolledBackTransaction(CDOTransaction transaction) {
            this.cleanUp();
        }

        private void cleanUp() {
            String commitComment;
            if (this.lastComment != null && (commitComment = CDOTransactionCommentator.this.transaction.getCommitComment()) != null && commitComment.endsWith(this.lastComment)) {
                commitComment = commitComment.substring(0, commitComment.length() - this.lastComment.length());
                CDOTransactionCommentator.this.transaction.setCommitComment(commitComment.trim());
            }
            this.lastComment = null;
        }
    };
    private CDOTransaction transaction;

    public CDOTransactionCommentator(CDOTransaction transaction) {
        this.transaction = transaction;
        transaction.addListener(this.transactionListener);
        transaction.addTransactionHandler(this.transactionHandler);
    }

    public final CDOTransaction getTransaction() {
        return this.transaction;
    }

    public final boolean isClosed() {
        return this.transaction == null;
    }

    public void close() {
        this.transaction.removeTransactionHandler(this.transactionHandler);
        this.transaction.removeListener(this.transactionListener);
        this.transaction = null;
    }

    protected String createComment(CDOCommitContext commitContext) {
        StringBuilder builder = new StringBuilder("<");
        CDOTransactionCommentator.appendSummary(builder, commitContext);
        builder.append(">");
        return builder.toString();
    }

    public static void appendSummary(StringBuilder builder, CDOCommitContext commitContext) {
        boolean needComma = false;
        needComma |= CDOTransactionCommentator.appendSummary(builder, needComma, commitContext.getNewObjects().size(), "addition");
        needComma |= CDOTransactionCommentator.appendSummary(builder, needComma, commitContext.getDirtyObjects().size(), "change");
        needComma |= CDOTransactionCommentator.appendSummary(builder, needComma, commitContext.getDetachedObjects().size(), "removal");
    }

    private static boolean appendSummary(StringBuilder builder, boolean needComma, int count, String label) {
        if (count > 0) {
            if (needComma) {
                builder.append(", ");
            }
            builder.append(count);
            builder.append(" ");
            builder.append(label);
            if (count > 1) {
                builder.append("s");
            }
            return true;
        }
        return false;
    }
}

