/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.session.remote;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.HexUtil;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;

public final class CDORemoteSessionMessage {
    private String type;
    private Priority priority;
    private byte[] data;

    public CDORemoteSessionMessage(String type, Priority priority, byte[] data) {
        CheckUtil.checkArg((Object)type, (String)"type");
        CheckUtil.checkArg((Object)((Object)priority), (String)"priority");
        this.type = type;
        this.priority = priority;
        this.data = data;
    }

    public CDORemoteSessionMessage(String type, Priority priority) {
        this(type, priority, null);
    }

    public CDORemoteSessionMessage(String type, byte[] data) {
        this(type, Priority.NORMAL, data);
    }

    public CDORemoteSessionMessage(String type) {
        this(type, Priority.NORMAL, null);
    }

    public CDORemoteSessionMessage(ExtendedDataInput in) throws IOException {
        this.type = in.readString();
        this.priority = Priority.values()[in.readByte()];
        this.data = in.readByteArray();
    }

    public synchronized void write(ExtendedDataOutput out) throws IOException {
        out.writeString(this.type);
        out.writeByte(this.priority.ordinal());
        out.writeByteArray(this.data);
    }

    public String getType() {
        return this.type;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public synchronized byte[] getData() {
        return this.copyData(this.data);
    }

    public synchronized void setData(byte[] data) {
        this.data = this.copyData(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedDataInputStream getInputStream() {
        byte[] copy;
        CDORemoteSessionMessage cDORemoteSessionMessage = this;
        synchronized (cDORemoteSessionMessage) {
            block4: {
                copy = this.copyData(this.data);
                if (copy != null) break block4;
                return null;
            }
        }
        return new ExtendedDataInputStream((InputStream)new ByteArrayInputStream(copy));
    }

    public ExtendedDataOutputStream getOutputStream() {
        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        return new ExtendedDataOutputStream(baos){

            public void close() throws IOException {
                super.close();
                CDORemoteSessionMessage.this.setData(baos.toByteArray());
            }
        };
    }

    public String toString() {
        return MessageFormat.format("Message[type={0}, priority={1}, data={3}]", new Object[]{this.type, this.priority, HexUtil.bytesToHex((byte[])this.data)});
    }

    private byte[] copyData(byte[] src) {
        if (src == null) {
            return null;
        }
        byte[] copy = new byte[src.length];
        System.arraycopy(src, 0, copy, 0, src.length);
        return copy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Priority {
        VERY_LOW,
        LOW,
        NORMAL,
        HIGH,
        VERY_HIGH;

    }
}

