/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.search.ui.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.viewersearch.impl.ViewerSearchService;
import org.eclipse.papyrus.uml.search.ui.Activator;
import org.eclipse.papyrus.uml.search.ui.Messages;
import org.eclipse.papyrus.uml.search.ui.providers.ParticipantTypeAttribute;
import org.eclipse.papyrus.uml.search.ui.providers.ParticipantTypeElement;
import org.eclipse.papyrus.uml.search.ui.query.AbstractPapyrusQuery;
import org.eclipse.papyrus.uml.search.ui.results.PapyrusSearchResult;
import org.eclipse.papyrus.uml.search.ui.validator.ParticipantValidator;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.papyrus.views.search.regex.PatternHelper;
import org.eclipse.papyrus.views.search.results.AbstractResultEntry;
import org.eclipse.papyrus.views.search.results.AttributeMatch;
import org.eclipse.papyrus.views.search.results.ModelElementMatch;
import org.eclipse.papyrus.views.search.results.ViewerMatch;
import org.eclipse.papyrus.views.search.scope.ScopeEntry;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapyrusAdvancedQuery
extends AbstractPapyrusQuery {
    private Set<Object> sources;
    private String searchQueryText;
    private boolean isCaseSensitive;
    private boolean isRegularExpression;
    private Collection<ScopeEntry> scopeEntries;
    private Object[] participantsChecked;
    private PapyrusSearchResult results;
    private HashMap<EObject, List<EAttribute>> participantsList;
    protected Set<AbstractResultEntry> fResults = null;
    private HashMap<Stereotype, ArrayList<Property>> stereotypeList;
    private List<EAttribute> attributesList;
    private List<Property> propertyList = new ArrayList<Property>();
    private boolean searchForAllSter;

    @Override
    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    @Override
    public boolean isRegularExpression() {
        return this.isRegularExpression;
    }

    public PapyrusAdvancedQuery(String searchQueryText, boolean isCaseSensitive, boolean isRegularExpression, Collection<ScopeEntry> scopeEntries, Object[] participantsChecked, boolean searchForAllSter) {
        this.sources = new HashSet<Object>();
        this.searchQueryText = searchQueryText;
        this.isCaseSensitive = isCaseSensitive;
        this.isRegularExpression = isRegularExpression;
        this.scopeEntries = scopeEntries;
        this.participantsChecked = participantsChecked;
        this.searchForAllSter = searchForAllSter;
        this.results = new PapyrusSearchResult(this);
        this.participantsList = new HashMap();
        this.stereotypeList = new HashMap();
        Object[] objectArray = this.participantsChecked;
        int n = this.participantsChecked.length;
        int n2 = 0;
        while (n2 < n) {
            Object participant = objectArray[n2];
            if (participant instanceof ParticipantTypeElement) {
                Object attributesFound;
                int n3;
                int n4;
                Object[] objectArray2;
                ArrayList<Object> attributesChecked;
                if (((ParticipantTypeElement)participant).getElement() instanceof ENamedElement) {
                    attributesChecked = new ArrayList<Object>();
                    objectArray2 = this.participantsChecked;
                    n4 = this.participantsChecked.length;
                    n3 = 0;
                    while (n3 < n4) {
                        attributesFound = objectArray2[n3];
                        if (attributesFound instanceof ParticipantTypeAttribute && ((ParticipantTypeAttribute)attributesFound).getParent() == participant) {
                            attributesChecked.add((EAttribute)((ParticipantTypeAttribute)attributesFound).getElement());
                        }
                        ++n3;
                    }
                    this.participantsList.put(((ParticipantTypeElement)participant).getElement(), attributesChecked);
                } else if (((ParticipantTypeElement)participant).getElement() instanceof Stereotype) {
                    attributesChecked = new ArrayList();
                    objectArray2 = this.participantsChecked;
                    n4 = this.participantsChecked.length;
                    n3 = 0;
                    while (n3 < n4) {
                        attributesFound = objectArray2[n3];
                        if (attributesFound instanceof ParticipantTypeAttribute && ((ParticipantTypeAttribute)attributesFound).getParent() == participant) {
                            attributesChecked.add((Property)((ParticipantTypeAttribute)attributesFound).getElement());
                        }
                        ++n3;
                    }
                    this.stereotypeList.put((Stereotype)((ParticipantTypeElement)participant).getElement(), attributesChecked);
                }
            }
            ++n2;
        }
        this.fResults = new HashSet<AbstractResultEntry>();
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        this.results.removeAll();
        this.fResults.clear();
        for (ScopeEntry scopeEntry : this.scopeEntries) {
            try {
                if (scopeEntry.getModelSet() == null) continue;
                UmlModel umlModel = (UmlModel)scopeEntry.getModelSet().getModelChecked("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
                EObject root = umlModel.lookupRoot();
                Collection<EObject> participants = ParticipantValidator.getInstance().getParticipants(root, this.participantsList.keySet().toArray());
                Collection<EObject> stereotypesParticipants = ParticipantValidator.getInstance().getParticipantsStereotype(root, this.stereotypeList.keySet().toArray());
                if (this.searchForAllSter) {
                    if (this.participantsList.keySet().size() == 0) {
                        stereotypesParticipants = this.getElementsWithAllSter(stereotypesParticipants);
                        this.evaluateStereotypes(stereotypesParticipants, scopeEntry);
                        continue;
                    }
                    participants = this.getElementsWithAllSter(participants);
                    this.evaluate(participants, scopeEntry);
                    continue;
                }
                this.evaluate(participants, scopeEntry);
                this.evaluateStereotypes(stereotypesParticipants, scopeEntry);
            }
            catch (NotFoundException e) {
                Activator.log.error(String.valueOf(Messages.PapyrusQuery_0) + scopeEntry.getModelSet(), (Throwable)e);
            }
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    private Collection<EObject> getElementsWithAllSter(Collection<EObject> initialParticipants) {
        ArrayList<EObject> participantsToKeep = new ArrayList<EObject>();
        for (EObject participants : initialParticipants) {
            if (!(participants instanceof Element)) continue;
            int numberOfStereotypeToBeApplied = this.stereotypeList.size();
            int numberOfStereotypeMatching = 0;
            if (numberOfStereotypeToBeApplied != ((Element)participants).getAppliedStereotypes().size()) continue;
            for (Stereotype stereotypeToBeApplied : this.stereotypeList.keySet()) {
                for (Stereotype stereotypeApplied : ((Element)participants).getAppliedStereotypes()) {
                    if (!EcoreUtil.equals((EObject)stereotypeToBeApplied, (EObject)stereotypeApplied)) continue;
                    ++numberOfStereotypeMatching;
                }
            }
            if (numberOfStereotypeMatching != numberOfStereotypeToBeApplied) continue;
            participantsToKeep.add(participants);
        }
        return participantsToKeep;
    }

    /*
     * Unable to fully structure code
     */
    protected void evaluateAndAddToResult(String value, Object attribute, Pattern pattern, Object participant, ScopeEntry scopeEntry, Stereotype stereotype) {
        block3: {
            value = value != null ? value : "";
            m = pattern.matcher(value);
            if (!this.isRegularExpression) ** GOTO lbl16
            if (!m.matches()) break block3;
            start = m.start();
            end = m.end();
            match = new AttributeMatch(start, end, participant, scopeEntry, attribute, stereotype);
            this.fResults.add((AbstractResultEntry)match);
            break block3;
lbl-1000:
            // 1 sources

            {
                start = m.start();
                end = m.end();
                match = new AttributeMatch(start, end, participant, scopeEntry, attribute, stereotype);
                this.fResults.add((AbstractResultEntry)match);
lbl16:
                // 2 sources

                ** while (m.find())
            }
        }
    }

    protected void evaluate(Collection<EObject> participants, ScopeEntry scopeEntry) {
        for (EObject participant : participants) {
            Pattern pattern;
            if (this.searchQueryText.equals("")) {
                this.fResults.add((AbstractResultEntry)new ModelElementMatch((Object)participant, scopeEntry));
                continue;
            }
            String query = this.searchQueryText;
            if (this.searchQueryText.equals("")) {
                query = ".*";
            }
            if ((pattern = PatternHelper.getInstance().createPattern(query, this.isCaseSensitive, this.isRegularExpression)) == null) continue;
            this.attributesList = this.participantsList.get(participant.eClass()).size() == 0 ? participant.eClass().getEAllAttributes() : this.participantsList.get(participant.eClass());
            for (EAttribute attribute : this.attributesList) {
                String stringValue;
                Object value = participant.eGet((EStructuralFeature)attribute);
                if (value instanceof String) {
                    stringValue = (String)value;
                    this.evaluateAndAddToResult(stringValue, attribute, pattern, participant, scopeEntry, null);
                    continue;
                }
                stringValue = String.valueOf(value);
                this.evaluateAndAddToResult(stringValue, attribute, pattern, participant, scopeEntry, null);
            }
        }
        this.findInDiagram(scopeEntry);
    }

    protected void evaluateStereotypes(Collection<EObject> participants, ScopeEntry scopeEntry) {
        for (EObject participant : participants) {
            Pattern pattern;
            if (this.searchQueryText.equals("")) {
                this.fResults.add((AbstractResultEntry)new ModelElementMatch((Object)participant, scopeEntry));
                continue;
            }
            String query = this.searchQueryText;
            if (this.searchQueryText.equals("")) {
                query = ".*";
            }
            if ((pattern = PatternHelper.getInstance().createPattern(query, this.isCaseSensitive, this.isRegularExpression)) == null) continue;
            EList stereotypesApplied = ((Element)participant).getAppliedStereotypes();
            for (Stereotype stereotype : stereotypesApplied) {
                for (Stereotype stereotypeSelected : this.stereotypeList.keySet()) {
                    if (!EcoreUtil.equals((EObject)stereotype, (EObject)stereotypeSelected)) continue;
                    if (this.stereotypeList.get(stereotypeSelected).size() == 0) {
                        this.propertyList = this.getStereotypesAttributes(stereotype);
                        for (Property property : this.propertyList) {
                            String stringValue;
                            Object value = ((Element)participant).getValue(stereotype, property.getName());
                            if (value == null) continue;
                            if (value instanceof String) {
                                stringValue = (String)value;
                                this.evaluateAndAddToResult(stringValue, property, pattern, participant, scopeEntry, stereotype);
                                continue;
                            }
                            stringValue = String.valueOf(value);
                            this.evaluateAndAddToResult(stringValue, property, pattern, participant, scopeEntry, stereotype);
                        }
                        continue;
                    }
                    this.propertyList = this.getStereotypesAttributes(stereotype);
                    for (Property property : this.propertyList) {
                        for (Property property2 : this.stereotypeList.get(stereotypeSelected)) {
                            String value;
                            if (!EcoreUtil.equals((EObject)property, (EObject)property2) || (value = this.getStringValueOfProperty((Element)participant, stereotype, property)) == null) continue;
                            this.evaluateAndAddToResult(value, property, pattern, participant, scopeEntry, stereotype);
                        }
                    }
                }
            }
        }
        this.findInDiagram(scopeEntry);
    }

    private String getStringValueOfProperty(Element element, Stereotype stereotype, Property property) {
        Object value = element.getValue(stereotype, property.getName());
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof EnumerationLiteral) {
            return ((EnumerationLiteral)value).getName();
        }
        return String.valueOf(value);
    }

    public List<Property> getStereotypesAttributes(Object parentElement) {
        ArrayList<Property> result = new ArrayList<Property>();
        if (parentElement instanceof Stereotype) {
            for (Property property : ((Stereotype)parentElement).getAllAttributes()) {
                if (property.getName().startsWith("base_") || !(property.getType() instanceof Element) || !UMLUtil.isBoolean((Type)property.getType()) && !UMLUtil.isString((Type)property.getType()) && !UMLUtil.isInteger((Type)property.getType()) && !UMLUtil.isReal((Type)property.getType()) && !UMLUtil.isUnlimitedNatural((Type)property.getType()) && !(property.getType() instanceof Enumeration)) continue;
                result.add(property);
            }
        }
        return result;
    }

    protected void findInDiagram(ScopeEntry scopeEntry) {
        ViewerSearchService viewerSearcherService = new ViewerSearchService();
        try {
            viewerSearcherService.startService();
            for (AbstractResultEntry match : this.fResults) {
                if (match instanceof AttributeMatch) {
                    this.sources.add(((AttributeMatch)match).getSource());
                    continue;
                }
                this.sources.add(match.getSource());
            }
            Map viewersMappings = viewerSearcherService.getViewers(this.sources, scopeEntry.getModelSet());
            for (Object containingModelSet : viewersMappings.keySet()) {
                for (Object view : ((Map)viewersMappings.get(containingModelSet)).keySet()) {
                    Object semanticElement = ((Map)viewersMappings.get(containingModelSet)).get(view);
                    ViewerMatch viewMatch = new ViewerMatch(view, scopeEntry, semanticElement);
                    this.fResults.add((AbstractResultEntry)viewMatch);
                }
            }
        }
        catch (ServiceException e) {
            Activator.log.error(String.valueOf(Messages.PapyrusQuery_5) + scopeEntry.getModelSet(), (Throwable)e);
        }
    }

    public String getLabel() {
        return Messages.PapyrusQuery_6;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        for (AbstractResultEntry match : this.fResults) {
            this.results.addMatch((Match)match);
        }
        return this.results;
    }

    @Override
    public String getSearchQueryText() {
        return this.searchQueryText;
    }
}

