/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools.tasks;

import java.util.List;
import org.apache.tools.ant.BuildException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.tools.Messages;
import org.eclipse.equinox.p2.internal.repository.tools.Repo2Runnable;
import org.eclipse.equinox.p2.internal.repository.tools.tasks.AbstractRepositoryTask;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.osgi.util.NLS;

public class Repo2RunnableTask
extends AbstractRepositoryTask {
    private boolean failOnError = true;
    private boolean flagAsRunnable = false;

    public Repo2RunnableTask() {
        this.application = new Repo2Runnable();
    }

    public void execute() throws BuildException {
        try {
            this.prepareSourceRepos();
            this.application.initializeRepos(null);
            List<IInstallableUnit> ius = this.prepareIUs();
            if (!(ius != null && ius.size() != 0 || this.application.hasArtifactSources() || this.application.hasMetadataSources())) {
                throw new BuildException(Messages.exception_needIUsOrNonEmptyRepo);
            }
            this.application.setSourceIUs(ius);
            ((Repo2Runnable)this.application).setFlagAsRunnable(this.flagAsRunnable);
            IStatus result = this.application.run(null);
            if (this.failOnError && result.matches(4)) {
                throw new ProvisionException(result);
            }
        }
        catch (ProvisionException e) {
            if (this.failOnError) {
                throw new BuildException(NLS.bind((String)Messages.Repo2RunnableTask_errorTransforming, (Object)(e.getMessage() != null ? e.getMessage() : e.toString())), (Throwable)e);
            }
            this.getProject().log(NLS.bind((String)Messages.Repo2RunnableTask_errorTransforming, (Object)(e.getMessage() != null ? e.getMessage() : e.toString())), 1);
            this.getProject().log(e.getMessage(), 1);
        }
    }

    public void setFailOnError(boolean fail) {
        this.failOnError = fail;
    }

    public void setFlagAsRunnable(boolean runnable) {
        this.flagAsRunnable = runnable;
    }
}

