/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools.tasks;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.tools.ant.BuildException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.tools.CompositeRepositoryApplication;
import org.eclipse.equinox.p2.internal.repository.tools.RepositoryDescriptor;
import org.eclipse.equinox.p2.internal.repository.tools.tasks.AbstractRepositoryTask;
import org.eclipse.equinox.p2.internal.repository.tools.tasks.DestinationRepository;
import org.eclipse.equinox.p2.internal.repository.tools.tasks.RepositoryList;
import org.eclipse.equinox.p2.internal.repository.tools.tasks.TaskHelper;

public class CompositeRepositoryTask
extends AbstractRepositoryTask {
    private static String COMPOSITE_REMOVE = "p2.composite.artifact.repository.remove";
    private static String COMPOSITE_ADD = "p2.composite.artifact.repository.add";

    public CompositeRepositoryTask() {
        this.application = new CompositeRepositoryApplication();
    }

    public void execute() throws BuildException {
        try {
            IStatus result = this.application.run(null);
            if (result.matches(4)) {
                throw new BuildException(TaskHelper.statusToString(result, 4, null).toString());
            }
        }
        catch (ProvisionException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void addConfiguredAdd(RepositoryList list) {
        if (list.getRepoLocation() != null) {
            RepositoryDescriptor descriptor = new RepositoryDescriptor();
            try {
                descriptor.setLocation(URIUtil.fromString((String)list.getRepoLocation()));
                descriptor.setOptional(list.isOptional());
                if (!list.isBoth()) {
                    descriptor.setKind(list.isArtifact() ? "A" : "M");
                }
                ((CompositeRepositoryApplication)this.application).addChild(descriptor);
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        for (DestinationRepository repo : list.getRepositoryList()) {
            ((CompositeRepositoryApplication)this.application).addChild(repo.getDescriptor());
        }
    }

    public void addConfiguredRemove(RepositoryList list) {
        if (list.getRepoLocation() != null) {
            RepositoryDescriptor descriptor = new RepositoryDescriptor();
            try {
                descriptor.setLocation(URIUtil.fromString((String)list.getRepoLocation()));
                descriptor.setOptional(list.isOptional());
                if (!list.isBoth()) {
                    descriptor.setKind(list.isArtifact() ? "A" : "M");
                }
                ((CompositeRepositoryApplication)this.application).removeChild(descriptor);
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        for (DestinationRepository repo : list.getRepositoryList()) {
            ((CompositeRepositoryApplication)this.application).removeChild(repo.getDescriptor());
        }
    }

    public void setFailOnExists(boolean value) {
        ((CompositeRepositoryApplication)this.application).setFailOnExists(value);
    }

    public void setValidate(String value) {
        ((CompositeRepositoryApplication)this.application).setComparator(value);
    }

    public void setLocation(String value) {
        super.setDestination(value);
    }

    public void setChild(String value) throws URISyntaxException {
        URI childURI = URIUtil.fromString((String)value);
        RepositoryDescriptor repo = new RepositoryDescriptor();
        repo.setLocation(childURI);
        if (this.getTaskName().equals(COMPOSITE_ADD)) {
            ((CompositeRepositoryApplication)this.application).addChild(repo);
        } else if (this.getTaskName().equals(COMPOSITE_REMOVE)) {
            ((CompositeRepositoryApplication)this.application).removeChild(repo);
        }
    }

    public void setComparatorID(String value) {
        if (value != null && !value.startsWith("${")) {
            ((CompositeRepositoryApplication)this.application).setComparator(value);
        }
    }

    public void setAllChildren(String value) {
        if (value != null && !value.startsWith("${")) {
            ((CompositeRepositoryApplication)this.application).setRemoveAll(Boolean.valueOf(value).booleanValue());
        }
    }
}

