/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools.tasks;

import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Parameter;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.repository.artifact.ArtifactDescriptorQuery;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactDescription
extends DataType {
    private String classifier = null;
    private String id = null;
    private String version = null;
    private String range = null;
    private Map<String, String> properties = null;

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setRange(String range) {
        this.range = range;
    }

    public void addConfiguredProperty(Parameter property) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(property.getName(), property.getValue());
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public IQuery<IArtifactKey> createKeyQuery() {
        VersionRange keyRange = null;
        if (this.range != null) {
            keyRange = new VersionRange(this.range);
        } else if (this.version != null) {
            Version keyVersion = Version.parseVersion((String)this.version);
            keyRange = new VersionRange(keyVersion, true, keyVersion, true);
        }
        return new ArtifactKeyQuery(this.classifier, this.id, keyRange);
    }

    public IQuery<IArtifactDescriptor> createDescriptorQuery() {
        VersionRange keyRange = null;
        if (this.range != null) {
            keyRange = new VersionRange(this.range);
        } else if (this.version != null) {
            Version keyVersion = Version.parseVersion((String)this.version);
            keyRange = new VersionRange(keyVersion, true, keyVersion, true);
        }
        return new ArtifactDescriptorQuery(this.id, keyRange, null, this.properties);
    }
}

