/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.tasks;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.search.MissingRefReportConverter;
import org.eclipse.pde.api.tools.internal.tasks.CommonUtilsTask;
import org.eclipse.pde.api.tools.internal.tasks.Messages;
import org.eclipse.pde.api.tools.internal.util.Util;

public final class MissingRefProblemsReportConversionTask
extends CommonUtilsTask {
    private String xmlReportsLocation = null;
    private String htmlReportsLocation = null;

    public void setDebug(String debugValue) {
        this.debug = Boolean.toString(true).equals(debugValue);
    }

    public void setHtmlFiles(String htmlFilesLocation) {
        this.htmlReportsLocation = htmlFilesLocation;
    }

    public void setXmlFiles(String xmlFilesLocation) {
        this.xmlReportsLocation = xmlFilesLocation;
    }

    public void execute() throws BuildException {
        if (this.xmlReportsLocation == null) {
            throw new BuildException(Messages.no_xml_location);
        }
        if (this.htmlReportsLocation == null) {
            throw new BuildException(Messages.no_html_location);
        }
        if (this.debug) {
            System.out.println("XML report location: " + this.xmlReportsLocation);
            System.out.println("HTML report location: " + this.htmlReportsLocation);
        }
        try {
            Util.delete((File)new File(this.htmlReportsLocation));
            MissingRefReportConverter converter = new MissingRefReportConverter(this.htmlReportsLocation, this.xmlReportsLocation);
            ApiPlugin.DEBUG_USE_REPORT_CONVERTER = this.debug;
            converter.convert(null, (IProgressMonitor)new NullProgressMonitor());
            File index = converter.getReportIndex();
            System.out.println(NLS.bind((String)Messages.ApiUseReportConversionTask_conversion_complete, (Object)index.getAbsolutePath()));
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }
}

