/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.tasks;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.tools.ant.BuildException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.model.StubApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.comparator.ApiComparator;
import org.eclipse.pde.api.tools.internal.provisional.comparator.ApiScope;
import org.eclipse.pde.api.tools.internal.provisional.comparator.DeltaVisitor;
import org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiScope;
import org.eclipse.pde.api.tools.internal.tasks.CommonUtilsTask;
import org.eclipse.pde.api.tools.internal.tasks.FilterListDeltaVisitor;
import org.eclipse.pde.api.tools.internal.tasks.Messages;
import org.eclipse.pde.api.tools.internal.util.FilteredElements;
import org.eclipse.pde.api.tools.internal.util.UtilMessages;

public class CompareTask
extends CommonUtilsTask {
    private static final String VISIBILITY_ALL = "ALL";
    private static final String VISIBILITY_API = "API";
    private static final String REPORT_XML_FILE_NAME = "compare.xml";
    private int visibilityModifiers = 1;
    private String componentsList;
    private String excludeListLocation;
    private String includeListLocation;

    public void execute() throws BuildException {
        block48: {
            if (this.referenceBaselineLocation == null || this.currentBaselineLocation == null || this.reportLocation == null) {
                StringWriter out = new StringWriter();
                PrintWriter writer = new PrintWriter(out);
                writer.println(NLS.bind((String)Messages.printArguments, (Object[])new String[]{this.referenceBaselineLocation, this.currentBaselineLocation, this.reportLocation}));
                writer.flush();
                writer.close();
                throw new BuildException(String.valueOf(out.getBuffer()));
            }
            if (this.debug) {
                System.out.println("Reference baseline : " + this.referenceBaselineLocation);
                System.out.println("Baseline to compare : " + this.currentBaselineLocation);
                System.out.println("Report location : " + this.reportLocation);
                System.out.println("Component's list : " + this.componentsList);
                if (this.excludeListLocation != null) {
                    System.out.println("exclude list location : " + this.excludeListLocation);
                } else {
                    System.out.println("No exclude list location");
                }
                if (this.includeListLocation != null) {
                    System.out.println("include list location : " + this.includeListLocation);
                } else {
                    System.out.println("No include list location");
                }
            }
            File referenceInstallDir = this.extractSDK("referenceBaseline", this.referenceBaselineLocation);
            File baselineInstallDir = this.extractSDK("currentBaseline", this.currentBaselineLocation);
            IApiBaseline referenceBaseline = this.createBaseline("reference_baseline", referenceInstallDir.getAbsolutePath(), this.eeFileLocation);
            IApiBaseline currentBaseline = this.createBaseline("current_baseline", baselineInstallDir.getAbsolutePath(), this.eeFileLocation);
            IDelta delta = null;
            FilteredElements excludedElements = CommonUtilsTask.initializeFilteredElements(this.excludeListLocation, currentBaseline, this.debug);
            if (this.debug) {
                System.out.println("====================================================================================");
                System.out.println("Excluded elements list:");
                System.out.println(excludedElements);
            }
            FilteredElements includedElements = CommonUtilsTask.initializeFilteredElements(this.includeListLocation, currentBaseline, this.debug);
            if (this.debug) {
                System.out.println("====================================================================================");
                System.out.println("Included elements list:");
                System.out.println(includedElements);
            }
            ApiScope scope = new ApiScope();
            if (this.componentsList != null) {
                IApiComponent[] apiComponents = currentBaseline.getApiComponents();
                String[] componentsNames = this.componentsList.split(",");
                if (componentsNames.length == 0) {
                    scope.addElement((IApiElement)currentBaseline);
                } else {
                    int i = 0;
                    int max = componentsNames.length;
                    while (i < max) {
                        String componentName = componentsNames[i];
                        if ((componentName = componentName.trim()).startsWith("R:")) {
                            componentName = componentName.substring(2);
                            Pattern pattern = null;
                            try {
                                pattern = Pattern.compile(componentName);
                                int j = 0;
                                int max2 = apiComponents.length;
                                while (j < max2) {
                                    IApiComponent apiComponent = apiComponents[j];
                                    String componentId = apiComponent.getSymbolicName();
                                    Matcher matcher = pattern.matcher(componentId);
                                    if (matcher.matches()) {
                                        scope.addElement((IApiElement)apiComponent);
                                    }
                                    ++j;
                                }
                            }
                            catch (PatternSyntaxException patternSyntaxException) {
                                throw new BuildException(NLS.bind((String)UtilMessages.comparison_invalidRegularExpression, (Object)componentName));
                            }
                        } else {
                            IApiComponent apiComponent = currentBaseline.getApiComponent(componentName);
                            if (apiComponent != null) {
                                scope.addElement((IApiElement)apiComponent);
                            }
                        }
                        ++i;
                    }
                }
            } else {
                scope.addElement((IApiElement)currentBaseline);
            }
            try {
                try {
                    delta = ApiComparator.compare((IApiScope)scope, (IApiBaseline)referenceBaseline, (int)this.visibilityModifiers, (boolean)false, null);
                }
                catch (CoreException e) {
                    throw new BuildException(NLS.bind((String)Messages.illegalElementInScope, (Object)e.getMessage()));
                }
            }
            finally {
                referenceBaseline.dispose();
                currentBaseline.dispose();
                StubApiComponent.disposeAllCaches();
                this.deleteBaseline(this.referenceBaselineLocation, referenceInstallDir);
                this.deleteBaseline(this.currentBaselineLocation, baselineInstallDir);
            }
            if (delta == null) {
                throw new BuildException(Messages.errorInComparison);
            }
            BufferedWriter writer = null;
            File outputDir = new File(this.reportLocation);
            if (!outputDir.exists() && !outputDir.mkdirs()) {
                throw new BuildException(NLS.bind((String)Messages.errorCreatingParentReportFile, (Object)outputDir.getAbsolutePath()));
            }
            File outputFile = new File(this.reportLocation, REPORT_XML_FILE_NAME);
            try {
                String potentialExcludeList;
                if (outputFile.exists()) {
                    outputFile.delete();
                }
                writer = new BufferedWriter(new FileWriter(outputFile));
                FilterListDeltaVisitor visitor = new FilterListDeltaVisitor(excludedElements, includedElements, 3);
                delta.accept((DeltaVisitor)visitor);
                writer.write(visitor.getXML());
                writer.flush();
                if (this.debug && (potentialExcludeList = visitor.getPotentialExcludeList()).length() != 0) {
                    System.out.println("Potential exclude list:");
                    System.out.println(potentialExcludeList);
                }
            }
            catch (IOException e) {
                ApiPlugin.log((Throwable)e);
                try {
                    if (writer != null) {
                        writer.close();
                    }
                    break block48;
                }
                catch (IOException iOException) {}
                break block48;
            }
            catch (CoreException e) {
                try {
                    ApiPlugin.log((Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (writer != null) {
                        writer.close();
                    }
                    break block48;
                }
                catch (IOException iOException) {}
                break block48;
            }
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void setDebug(String debugValue) {
        this.debug = Boolean.toString(true).equals(debugValue);
    }

    public void setProfile(String baselineLocation) {
        this.currentBaselineLocation = baselineLocation;
    }

    public void setBaseline(String baselineLocation) {
        this.referenceBaselineLocation = baselineLocation;
    }

    public void setReport(String reportLocation) {
        this.reportLocation = reportLocation;
    }

    public void setVisibility(String value) {
        if (this.debug) {
            System.out.println("Visibility : " + value);
        }
        if (VISIBILITY_ALL.equals(value)) {
            this.visibilityModifiers = 65535;
        } else if (VISIBILITY_API.equals(value)) {
            this.visibilityModifiers = 1;
        } else {
            throw new BuildException("The given value " + value + " is not equals to \"ALL \" or \"API\".");
        }
    }

    public void setComponents(String componentsList) {
        this.componentsList = componentsList;
    }

    public void setExcludeList(String excludeListLocation) {
        this.excludeListLocation = excludeListLocation;
    }

    public void setincludeList(String includeListLocation) {
        this.includeListLocation = includeListLocation;
    }
}

