/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.tasks;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.model.ApiModelFactory;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.tasks.Messages;
import org.eclipse.pde.api.tools.internal.util.FilteredElements;
import org.eclipse.pde.api.tools.internal.util.TarException;
import org.eclipse.pde.api.tools.internal.util.Util;

public abstract class CommonUtilsTask
extends Task {
    private static final String ECLIPSE_FOLDER_NAME = "eclipse";
    protected static final String CURRENT = "currentBaseline";
    protected static final String CURRENT_BASELINE_NAME = "current_baseline";
    protected static final String REFERENCE = "referenceBaseline";
    protected static final String REFERENCE_BASELINE_NAME = "reference_baseline";
    protected boolean debug;
    protected String eeFileLocation;
    protected String currentBaselineLocation;
    protected String referenceBaselineLocation;
    protected String excludeListLocation;
    protected String includeListLocation;
    protected String reportLocation;

    protected IApiBaseline createBaseline(String baselineName, String installLocation, String eeFileLocation) {
        try {
            IApiBaseline baseline = null;
            baseline = ApiPlugin.isRunningInFramework() ? ApiModelFactory.newApiBaseline((String)baselineName) : (eeFileLocation != null ? ApiModelFactory.newApiBaseline((String)baselineName, (File)new File(eeFileLocation)) : ApiModelFactory.newApiBaseline((String)baselineName, (File)Util.getEEDescriptionFile()));
            IApiComponent[] components = ApiModelFactory.addComponents((IApiBaseline)baseline, (String)installLocation, null);
            if (components.length == 0) {
                throw new BuildException(NLS.bind((String)Messages.directoryIsEmpty, (Object)installLocation));
            }
            return baseline;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return ApiModelFactory.newApiBaseline((String)baselineName);
        }
    }

    protected void deleteBaseline(String referenceLocation, File folder) {
        if (Util.isArchive((String)referenceLocation)) {
            Util.delete((File)folder.getParentFile());
        }
    }

    protected File extractSDK(String installDirName, String location) {
        File file = new File(location);
        File locationFile = file;
        if (!locationFile.exists()) {
            throw new BuildException(NLS.bind((String)Messages.fileDoesnotExist, (Object)location));
        }
        if (Util.isArchive((String)location)) {
            File tempDir = new File(System.getProperty("java.io.tmpdir"));
            File installDir = new File(tempDir, installDirName);
            if (installDir.exists() && !Util.delete((File)installDir)) {
                throw new BuildException(NLS.bind((String)Messages.couldNotDelete, (Object)installDir.getAbsolutePath()));
            }
            if (!installDir.mkdirs()) {
                throw new BuildException(NLS.bind((String)Messages.couldNotCreate, (Object)installDir.getAbsolutePath()));
            }
            try {
                if (Util.isZipJarFile((String)location)) {
                    Util.unzip((String)location, (String)installDir.getAbsolutePath());
                } else if (Util.isTGZFile((String)location)) {
                    Util.guntar((String)location, (String)installDir.getAbsolutePath());
                }
            }
            catch (IOException iOException) {
                throw new BuildException(NLS.bind((String)Messages.couldNotUnzip, (Object[])new String[]{location, installDir.getAbsolutePath()}));
            }
            catch (TarException tarException) {
                throw new BuildException(NLS.bind((String)Messages.couldNotUntar, (Object[])new String[]{location, installDir.getAbsolutePath()}));
            }
            return new File(installDir, ECLIPSE_FOLDER_NAME);
        }
        return locationFile;
    }

    protected static FilteredElements initializeFilteredElements(String filterListLocation, IApiBaseline baseline, boolean debug) throws BuildException {
        try {
            return Util.initializeRegexFilterList((String)filterListLocation, (IApiBaseline)baseline, (boolean)debug);
        }
        catch (CoreException e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected void saveReport(String componentID, String contents, String reportname) {
        block16: {
            File dir = new File(this.reportLocation);
            if (!dir.exists() && !dir.mkdirs()) {
                throw new BuildException(NLS.bind((String)Messages.errorCreatingReportDirectory, (Object)this.reportLocation));
            }
            if (componentID != null && !(dir = new File(dir, componentID)).exists() && !dir.mkdirs()) {
                throw new BuildException(NLS.bind((String)Messages.errorCreatingReportDirectory, (Object)dir));
            }
            File reportFile = new File(dir, reportname);
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(reportFile));
                    writer.write(contents);
                    writer.flush();
                }
                catch (IOException e) {
                    ApiPlugin.log((Throwable)e);
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected String[] parsePatterns(String patterns) {
        if (patterns == null || patterns.trim().length() == 0) {
            return null;
        }
        String[] strings = patterns.split(",");
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < strings.length) {
            String pattern = strings[i].trim();
            if (pattern.length() > 0) {
                list.add(pattern);
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    public static String convertToHtml(String s) {
        char[] contents = s.toCharArray();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int max = contents.length;
        while (i < max) {
            char c = contents[i];
            switch (c) {
                case '<': {
                    buffer.append("&lt;");
                    break;
                }
                case '>': {
                    buffer.append("&gt;");
                    break;
                }
                case '\"': {
                    buffer.append("&quot;");
                    break;
                }
                case '&': {
                    buffer.append("&amp;");
                    break;
                }
                case '^': {
                    buffer.append("&and;");
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++i;
        }
        return String.valueOf(buffer);
    }
}

