/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.tasks;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.jdt.core.Signature;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.tasks.CommonUtilsTask;
import org.eclipse.pde.api.tools.internal.tasks.Messages;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class APIDeprecationReportConversionTask
extends Task {
    boolean debug;
    private String htmlFileLocation;
    private String xmlFileLocation;

    private void dumpEndEntryForComponent(StringBuffer buffer, String componentID) {
        buffer.append(NLS.bind((String)Messages.deprecationReportTask_endComponentEntry, (Object)componentID));
    }

    private void dumpEntries(Map<String, List<Entry>> entries, StringBuffer buffer) {
        this.dumpHeader(buffer);
        ArrayList<Map.Entry<String, List<Entry>>> allEntries = new ArrayList<Map.Entry<String, List<Entry>>>();
        for (Map.Entry<String, List<Entry>> entry : entries.entrySet()) {
            allEntries.add(entry);
        }
        Collections.sort(allEntries, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Map.Entry entry1 = (Map.Entry)o1;
                Map.Entry entry2 = (Map.Entry)o2;
                return ((String)entry1.getKey()).compareTo((String)entry2.getKey());
            }
        });
        for (Map.Entry<String, List<Entry>> mapEntry : allEntries) {
            String key = mapEntry.getKey();
            List<Entry> values = mapEntry.getValue();
            this.dumpEntryForComponent(buffer, key);
            Collections.sort(values, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    Entry entry1 = (Entry)o1;
                    Entry entry2 = (Entry)o2;
                    String typeName1 = entry1.typeName;
                    String typeName2 = entry2.typeName;
                    if (typeName1 == null) {
                        if (typeName2 == null) {
                            return entry1.key.compareTo(entry2.key);
                        }
                        return -1;
                    }
                    if (typeName2 == null) {
                        return 1;
                    }
                    if (!typeName1.equals(typeName2)) {
                        return typeName1.compareTo(typeName2);
                    }
                    return entry1.key.compareTo(entry2.key);
                }
            });
            if (this.debug) {
                System.out.println("Entries for " + key);
            }
            for (Entry entry : values) {
                if (this.debug) {
                    if (entry.typeName != null) {
                        System.out.print(entry.typeName);
                        System.out.print('#');
                    }
                    System.out.println(entry.key);
                }
                this.dumpEntry(buffer, entry);
            }
            this.dumpEndEntryForComponent(buffer, key);
        }
        this.dumpFooter(buffer);
    }

    private void dumpEntry(StringBuffer buffer, Entry entry) {
        buffer.append(NLS.bind((String)Messages.deprecationReportTask_entry, (Object)entry.getDisplayKind(), (Object)entry.getDisplayString()));
    }

    private void dumpEntryForComponent(StringBuffer buffer, String componentID) {
        buffer.append(NLS.bind((String)Messages.deprecationReportTask_componentEntry, (Object)componentID));
    }

    private void dumpFooter(StringBuffer buffer) {
        buffer.append(Messages.deprecationReportTask_footer);
    }

    private void dumpHeader(StringBuffer buffer) {
        buffer.append(Messages.deprecationReportTask_header);
    }

    public void execute() throws BuildException {
        if (this.xmlFileLocation == null) {
            throw new BuildException(Messages.deprecationReportTask_missingXmlFileLocation);
        }
        if (this.debug) {
            System.out.println("xmlFileLocation : " + this.xmlFileLocation);
            System.out.println("htmlFileLocation : " + this.htmlFileLocation);
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = null;
        try {
            parser = factory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        if (parser == null) {
            throw new BuildException(Messages.deprecationReportTask_couldNotCreateSAXParser);
        }
        File file = new File(this.xmlFileLocation);
        if (this.htmlFileLocation == null) {
            this.htmlFileLocation = this.extractNameFromXMLName();
            if (this.debug) {
                System.out.println("output name :" + this.htmlFileLocation);
            }
        }
        try {
            ConverterDefaultHandler defaultHandler = new ConverterDefaultHandler(this.debug);
            parser.parse(file, (DefaultHandler)defaultHandler);
            StringBuffer buffer = new StringBuffer();
            this.dumpEntries(defaultHandler.getEntries(), buffer);
            this.writeOutput(buffer);
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {}
    }

    private String extractNameFromXMLName() {
        int index = this.xmlFileLocation.lastIndexOf(46);
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.xmlFileLocation.substring(0, index)).append(".html");
        return String.valueOf(buffer);
    }

    public void setDebug(String debugValue) {
        this.debug = Boolean.toString(true).equals(debugValue);
    }

    public void setHtmlFile(String htmlFilePath) {
        this.htmlFileLocation = htmlFilePath;
    }

    public void setXmlFile(String xmlFilePath) {
        this.xmlFileLocation = xmlFilePath;
    }

    private void writeOutput(StringBuffer buffer) throws IOException {
        FileWriter writer = null;
        BufferedWriter bufferedWriter = null;
        try {
            writer = new FileWriter(this.htmlFileLocation);
            bufferedWriter = new BufferedWriter(writer);
            bufferedWriter.write(String.valueOf(buffer));
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
    }

    static final class ConverterDefaultHandler
    extends DefaultHandler {
        private String[] arguments;
        private List<String> argumentsList;
        private String componentID;
        private boolean debug;
        private int flags;
        private String key;
        private String kind;
        private Map<String, List<Entry>> map = new HashMap<String, List<Entry>>();
        private String typename;
        private int elementType;

        public ConverterDefaultHandler(boolean debug) {
            this.debug = debug;
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if ("delta".equals(name)) {
                Entry entry = new Entry(this.flags, this.elementType, this.key, this.typename, this.arguments, this.kind);
                List<Entry> list = this.map.get(this.componentID);
                if (list != null) {
                    list.add(entry);
                } else {
                    ArrayList<Entry> value = new ArrayList<Entry>();
                    value.add(entry);
                    this.map.put(this.componentID, value);
                }
            } else if ("message_arguments".equals(name) && this.argumentsList != null && this.argumentsList.size() != 0) {
                this.arguments = new String[this.argumentsList.size()];
                this.argumentsList.toArray(this.arguments);
            }
        }

        public Map<String, List<Entry>> getEntries() {
            return this.map;
        }

        private void printAttribute(Attributes attributes, String name) {
            System.out.println("\t" + name + " = " + String.valueOf(attributes.getValue(name)));
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if ("delta".equals(name)) {
                if (this.debug) {
                    System.out.println("name : " + name);
                    this.printAttribute(attributes, "compatible");
                    this.printAttribute(attributes, "componentId");
                    this.printAttribute(attributes, "element_type");
                    this.printAttribute(attributes, "flags");
                    this.printAttribute(attributes, "key");
                    this.printAttribute(attributes, "kind");
                    this.printAttribute(attributes, "newModifiers");
                    this.printAttribute(attributes, "oldModifiers");
                    this.printAttribute(attributes, "restrictions");
                    this.printAttribute(attributes, "type_name");
                }
                this.componentID = attributes.getValue("componentId");
                this.flags = Integer.parseInt(attributes.getValue("flags"));
                this.elementType = Util.getDeltaElementTypeValue((String)attributes.getValue("element_type"));
                this.typename = attributes.getValue("type_name");
                this.key = attributes.getValue("key");
                this.kind = attributes.getValue("kind");
            } else if ("message_arguments".equals(name)) {
                if (this.argumentsList == null) {
                    this.argumentsList = new ArrayList<String>();
                } else {
                    this.argumentsList.clear();
                }
            } else if ("message_argument".equals(name)) {
                this.argumentsList.add(attributes.getValue("value"));
            }
        }
    }

    static class Entry {
        String[] arguments;
        int flags;
        int elementType;
        String key;
        String typeName;
        String kind;
        private static final String ADDED = "ADDED";
        private static final String REMOVED = "REMOVED";

        public Entry(int flags, int elementType, String key, String typeName, String[] arguments, String kind) {
            this.flags = flags;
            this.key = key.replace('/', '.');
            if (typeName != null) {
                this.typeName = typeName.replace('/', '.');
            }
            this.arguments = arguments;
            this.kind = kind;
            this.elementType = elementType;
        }

        public String getDisplayString() {
            StringBuffer buffer = new StringBuffer();
            if (this.typeName != null && this.typeName.length() != 0) {
                buffer.append(this.typeName);
                if (this.flags == 72) {
                    switch (this.elementType) {
                        case 1: 
                        case 4: 
                        case 6: 
                        case 8: {
                            if (this.typeName.equals(this.key)) break;
                            buffer.append('.');
                            buffer.append(this.key);
                            break;
                        }
                        case 5: {
                            int indexOf = this.key.indexOf(40);
                            if (indexOf == -1) {
                                return null;
                            }
                            int index = indexOf;
                            String selector = this.key.substring(0, index);
                            String descriptor = this.key.substring(index, this.key.length());
                            buffer.append('#');
                            buffer.append(Signature.toString((String)descriptor, (String)selector, null, (boolean)false, (boolean)false));
                            break;
                        }
                        case 9: {
                            int indexOf = this.key.indexOf(40);
                            if (indexOf == -1) {
                                return null;
                            }
                            int index = indexOf;
                            String selector = this.key.substring(0, index);
                            String descriptor = this.key.substring(index, this.key.length());
                            buffer.append('#');
                            buffer.append(Signature.toString((String)descriptor, (String)selector, null, (boolean)false, (boolean)true));
                            break;
                        }
                        case 7: {
                            buffer.append('#');
                            buffer.append(this.key);
                            break;
                        }
                    }
                }
            }
            return CommonUtilsTask.convertToHtml(String.valueOf(buffer));
        }

        public String getDisplayKind() {
            if (ADDED.equals(this.kind)) {
                return Messages.APIDeprecationReportConversionTask_KindDeprecated;
            }
            if (REMOVED.equals(this.kind)) {
                return Messages.APIDeprecationReportConversionTask_KindUndeprecated;
            }
            return Messages.ChangedElement;
        }
    }
}

