/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.utils;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMRootEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.utils.ASTBindingHelper;
import org.eclipse.ocl.examples.debug.vm.utils.ASTSyntheticNode;
import org.eclipse.ocl.examples.debug.vm.utils.ASTSyntheticNodeAccess;
import org.eclipse.ocl.examples.debug.vm.utils.IModuleSourceInfo;
import org.eclipse.ocl.examples.debug.vm.utils.VMStackTraceElement;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.FeatureCallExp;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.VariableExp;

public class VMStackTraceBuilder {
    @NonNull
    private static final String UNKNOWN_NAME = "<Unknown>";
    private static final int UNKNOWN_LINE_NUM = -1;
    @NonNull
    private IVMEvaluationEnvironment<?> fEvalEnv;

    public VMStackTraceBuilder(@NonNull IVMEvaluationEnvironment<?> evalEnv) {
        this.fEvalEnv = evalEnv;
    }

    public List<VMStackTraceElement> buildStackTrace() {
        LinkedList<VMStackTraceElement> elements = new LinkedList<VMStackTraceElement>();
        IVMEvaluationEnvironment<?> nextEnv = this.fEvalEnv;
        while (nextEnv != null) {
            IVMEvaluationEnvironment<?> parent = nextEnv.getParentEvaluationEnvironment();
            if (parent != null && parent.getDebuggableElement() != null) {
                elements.addLast(this.createStackElement(nextEnv));
            }
            nextEnv = nextEnv.getParentEvaluationEnvironment();
        }
        IVMRootEvaluationEnvironment<?> rootEnv = this.fEvalEnv.getRootEvaluationEnvironment();
        return Collections.unmodifiableList(elements);
    }

    @NonNull
    private VMStackTraceElement createStackElement(@NonNull IVMEvaluationEnvironment<?> env) {
        IModuleSourceInfo sourceInfo;
        String unitName = null;
        String moduleName = UNKNOWN_NAME;
        String operName = UNKNOWN_NAME;
        int lineNumber = -1;
        EObject module = null;
        NamedElement operation = env.getOperation();
        int resultOffset = VMStackTraceBuilder.getCurrentASTOffset(env);
        Object currentExpressionInOCL = env.getDebuggableElement();
        moduleName = currentExpressionInOCL.getName();
        if (operation == null) {
            ASTSyntheticNode astNode;
            operName = moduleName;
            if ((env.getCurrentIP() == module || resultOffset < -1) && (astNode = ASTSyntheticNodeAccess.getASTNode(module)) != null) {
                resultOffset = astNode.getStartPosition();
            }
        } else {
            operName = operation.getName();
        }
        IModuleSourceInfo iModuleSourceInfo = sourceInfo = module != null ? ASTBindingHelper.getModuleSourceBinding(module) : null;
        if (sourceInfo != null) {
            URI uri = sourceInfo.getSourceURI();
            unitName = uri.lastSegment();
            if (resultOffset >= 0) {
                lineNumber = sourceInfo.getLineNumberProvider().getLineNumber(resultOffset);
            }
        }
        return new VMStackTraceElement(moduleName, operName, unitName, lineNumber);
    }

    private static int getCurrentASTOffset(@NonNull IVMEvaluationEnvironment<?> evalEnv) {
        Element currentIPObject = evalEnv.getCurrentIP();
        if (currentIPObject instanceof Element) {
            EObject astContainer;
            Element astNode = currentIPObject;
            if (ASTBindingHelper.getStartPosition(astNode) < 0 && astNode instanceof VariableExp && (astContainer = astNode.eContainer()) instanceof FeatureCallExp) {
                astNode = (FeatureCallExp)astContainer;
            }
            return ASTBindingHelper.getStartPosition(astNode);
        }
        ASTSyntheticNode astNode = ASTSyntheticNodeAccess.getASTNode((EObject)currentIPObject);
        if (astNode != null) {
            return astNode.getStartPosition();
        }
        return -1;
    }
}

