/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.srclookup;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupParticipant;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.debug.vm.core.VMDebugCore;
import org.eclipse.ocl.examples.debug.vm.core.VMStackFrame;

public class VMSourceLookupParticipant
extends AbstractSourceLookupParticipant {
    @NonNull
    protected final VMDebugCore debugCore;

    public VMSourceLookupParticipant(@NonNull VMDebugCore debugCore) {
        this.debugCore = debugCore;
    }

    public String getSourceName(Object object) throws CoreException {
        if (object instanceof VMStackFrame) {
            VMStackFrame frame = (VMStackFrame)((Object)object);
            URI unitURI = frame.getUnitURI();
            if (unitURI.isFile()) {
                return unitURI.toFileString();
            }
            IFile sourceFile = this.findSourceFile(unitURI);
            if (sourceFile != null) {
                return sourceFile.getProjectRelativePath().toString();
            }
        }
        return null;
    }

    private IFile findSourceFile(URI unitURI) {
        return this.debugCore.resolveWorskpaceFile(unitURI);
    }
}

