/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.response;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.debug.vm.response.VMResponse;

public class VMBreakpointResponse
extends VMResponse {
    private static final long serialVersionUID = -8865684549088598599L;
    private long[] fAddedBreakpointsIDs;

    public VMBreakpointResponse() {
    }

    public VMBreakpointResponse(@NonNull List<Long> addedBreakpointIDs) {
        if (addedBreakpointIDs == null || addedBreakpointIDs.contains(null)) {
            throw new IllegalArgumentException("invalid installed breakpoints");
        }
        this.fAddedBreakpointsIDs = new long[addedBreakpointIDs.size()];
        int i = 0;
        for (Long id : addedBreakpointIDs) {
            this.fAddedBreakpointsIDs[i++] = id;
        }
    }

    public long[] getAddedBreakpointsIDs() {
        return this.fAddedBreakpointsIDs != null ? (long[])this.fAddedBreakpointsIDs.clone() : new long[]{};
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(String.valueOf(this.getClass().getSimpleName()) + "(" + VMBreakpointResponse.toStatusString(this.status));
        s.append(", {");
        int i = 0;
        while (i < this.fAddedBreakpointsIDs.length) {
            if (i > 0) {
                s.append(",");
            }
            s.append(this.fAddedBreakpointsIDs[i]);
            ++i;
        }
        s.append("}");
        return s.toString();
    }
}

