/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.evaluator;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.vm.UnitLocation;
import org.eclipse.ocl.examples.debug.vm.core.VMDebugCore;
import org.eclipse.ocl.examples.debug.vm.evaluator.IStepper;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMModelManager;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMRootEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.utils.VMRuntimeException;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;

public interface IVMEvaluationEnvironment<T extends NamedElement>
extends EvaluationEnvironment {
    @NonNull
    public Element getCurrentIP();

    @NonNull
    public UnitLocation getCurrentLocation();

    @NonNull
    public VMDebugCore getDebugCore();

    @NonNull
    public T getDebuggableElement();

    public int getDepth();

    public long getID();

    @NonNull
    public IVMModelManager getModelManager();

    @NonNull
    public Map<String, Resource> getModelParameterVariables();

    @NonNull
    public NamedElement getOperation();

    @NonNull
    public Variable getPCVariable();

    @Nullable
    public IVMEvaluationEnvironment<?> getParentEvaluationEnvironment();

    @NonNull
    public IVMRootEvaluationEnvironment<T> getRootEvaluationEnvironment();

    @NonNull
    public Stack<StepperEntry> getStepperStack();

    public boolean isDeferredExecution();

    public void processDeferredTasks();

    @NonNull
    public Element setCurrentIP(@NonNull Element var1);

    public void throwVMException(@NonNull VMRuntimeException var1);

    public static class StepperEntry {
        @NonNull
        public final IStepper stepper;
        @NonNull
        public final Element element;
        @Nullable
        private Map<DomainTypedElement, Object> partialResults;

        public StepperEntry(@NonNull IStepper stepper, @NonNull Element element) {
            this.stepper = stepper;
            this.element = element;
        }

        public void popFrom(@NonNull IVMEvaluationEnvironment<?> evaluationEnvironment) {
            Map<DomainTypedElement, Object> partialResults2 = this.partialResults;
            if (partialResults2 != null) {
                for (DomainTypedElement element : partialResults2.keySet()) {
                    if (element == null) continue;
                    evaluationEnvironment.remove(element);
                }
                partialResults2.clear();
                this.partialResults = null;
            }
        }

        public void pushTo(@NonNull IVMEvaluationEnvironment<?> evaluationEnvironment, @NonNull DomainTypedElement element, @Nullable Object value) {
            Map<DomainTypedElement, Object> partialResults2 = this.partialResults;
            if (partialResults2 == null) {
                this.partialResults = partialResults2 = new HashMap<DomainTypedElement, Object>();
            }
            partialResults2.put(element, value);
            evaluationEnvironment.replace(element, value);
        }
    }
}

