/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.core;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.ocl.examples.debug.vm.core.IVMDebugTarget;
import org.eclipse.ocl.examples.debug.vm.core.VMDebugElement;
import org.eclipse.ocl.examples.debug.vm.core.VMValue;
import org.eclipse.ocl.examples.debug.vm.data.VMVariableData;

public class VMVariable
extends VMDebugElement
implements IVariable {
    final VMVariableData vmVar;
    private final long fFrameID;
    protected IValue fValue;

    VMVariable(IVMDebugTarget debugTarget, VMVariableData vmVar, long frameID) {
        super(debugTarget);
        this.vmVar = vmVar;
        this.fFrameID = frameID;
    }

    public boolean isModelParameter() {
        return this.vmVar.kind == 4;
    }

    public boolean isLocalVariable() {
        return this.vmVar.kind == 0;
    }

    public boolean isCollectionElement() {
        return this.vmVar.kind == 6;
    }

    public boolean isPredefinedVariable() {
        return this.vmVar.kind == 3;
    }

    public boolean isIntermProperty() {
        return this.vmVar.kind == 5;
    }

    public boolean isAttribute() {
        return this.vmVar.kind == 1;
    }

    public boolean isReference() {
        return this.vmVar.kind == 2;
    }

    public IValue getValue() throws DebugException {
        if (this.fValue == null) {
            this.fValue = new VMValue(this.getOCLDebugTarget(), this.vmVar, this.fFrameID);
        }
        return this.fValue;
    }

    public String getName() throws DebugException {
        return this.vmVar.name;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.vmVar.type.declaringType;
    }

    public VMVariableData getVmVar() {
        return this.vmVar;
    }

    public boolean hasValueChanged() throws DebugException {
        return false;
    }

    public boolean supportsValueModification() {
        return false;
    }

    public void setValue(String expression) throws DebugException {
    }

    public void setValue(IValue value) throws DebugException {
    }

    public boolean verifyValue(String expression) throws DebugException {
        return false;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return false;
    }
}

