/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.debug.vm.VMEventListener;
import org.eclipse.ocl.examples.debug.vm.core.IVMDebugTarget;
import org.eclipse.ocl.examples.debug.vm.core.VMDebugCore;
import org.eclipse.ocl.examples.debug.vm.core.VMDebugElement;
import org.eclipse.ocl.examples.debug.vm.core.VMStackFrame;
import org.eclipse.ocl.examples.debug.vm.data.VMStackFrameData;
import org.eclipse.ocl.examples.debug.vm.data.VMSuspension;
import org.eclipse.ocl.examples.debug.vm.event.VMEvent;
import org.eclipse.ocl.examples.debug.vm.event.VMSuspendEvent;
import org.eclipse.ocl.examples.debug.vm.request.VMResumeRequest;

public class VMThread
extends VMDebugElement
implements IThread,
VMEventListener {
    private List<VMStackFrame> fFrames = new ArrayList<VMStackFrame>();
    private List<VMStackFrameData> fUnderlyingFrames;
    private VMStackFrameData fLastSuspendedFrame;
    private boolean fIsStepping = false;

    public VMThread(IVMDebugTarget target) {
        super(target);
        target.addVMEventListener(this);
        this.fireCreationEvent();
    }

    public boolean isDeferredExecution() {
        return false;
    }

    public boolean hasStackFrames() throws DebugException {
        return this.isSuspended();
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        if (this.isSuspended() && this.fFrames.size() == 0) {
            this.fillFrames();
        }
        return this.fFrames.toArray(new VMStackFrame[this.fFrames.size()]);
    }

    @Override
    @NonNull
    public VMDebugCore getDebugCore() {
        return this.getOCLDebugTarget().getDebugCore();
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        if (!this.hasStackFrames()) {
            return null;
        }
        IStackFrame[] frames = this.getStackFrames();
        return frames.length > 0 ? frames[0] : null;
    }

    public String getName() throws DebugException {
        return "OCLThread";
    }

    public IBreakpoint[] getBreakpoints() {
        IBreakpoint[] hostBreakpoints = new IBreakpoint[]{};
        return hostBreakpoints;
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.getDebugTarget().isSuspended();
    }

    public void resume() throws DebugException {
        this.setStepping(false);
        this.getDebugTarget().resume();
        this.fireResumeEvent(32);
    }

    public void suspend() throws DebugException {
        this.getDebugTarget().suspend();
    }

    public boolean canStepInto() {
        return this.isSuspended();
    }

    public void stepInto() throws DebugException {
        if (!this.canStepInto()) {
            return;
        }
        this.setStepping(true);
        this.fireResumeEvent(1);
        this.getOCLDebugTarget().sendRequest(new VMResumeRequest(VMSuspension.STEP_INTO));
    }

    public boolean canStepOver() {
        return this.isSuspended();
    }

    public void stepOver() throws DebugException {
        if (!this.canStepOver()) {
            return;
        }
        this.setStepping(true);
        this.fireResumeEvent(2);
        this.getOCLDebugTarget().sendRequest(new VMResumeRequest(VMSuspension.STEP_OVER));
    }

    public boolean canStepReturn() {
        return this.isSuspended();
    }

    public void stepReturn() throws DebugException {
        if (!this.canStepReturn()) {
            return;
        }
        this.setStepping(true);
        this.fireResumeEvent(4);
        this.getOCLDebugTarget().sendRequest(new VMResumeRequest(VMSuspension.STEP_RETURN));
    }

    public boolean isStepping() {
        return this.fIsStepping;
    }

    private void setStepping(boolean isStepping) {
        this.fIsStepping = isStepping;
    }

    public boolean canTerminate() {
        return this.getDebugTarget().canTerminate();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
        this.fFrames.clear();
    }

    @Override
    public void handleEvent(VMEvent event) {
        if (event instanceof VMSuspendEvent) {
            VMSuspendEvent suspendEvent = (VMSuspendEvent)event;
            if (!this.isStepping()) {
                this.fFrames.clear();
            } else {
                VMStackFrameData suspendedAtLocation = suspendEvent.stackFrames[0];
                if (this.fLastSuspendedFrame != null && suspendedAtLocation != null && suspendedAtLocation.id == this.fLastSuspendedFrame.id && !this.fFrames.isEmpty()) {
                    this.fFrames.get(0).setLocation(suspendedAtLocation);
                } else {
                    this.fFrames.clear();
                }
            }
            this.fUnderlyingFrames = Arrays.asList(suspendEvent.stackFrames);
            this.setStepping(false);
            DebugEvent debugEvent = new DebugEvent((Object)this, 2, suspendEvent.suspension.getDebugEventDetail());
            debugEvent.setData((Object)suspendEvent.location);
            this.fireEvent(debugEvent);
        }
    }

    private void fillFrames() {
        if (this.fUnderlyingFrames == null) {
            return;
        }
        for (VMStackFrameData frame : this.fUnderlyingFrames) {
            if (frame == null) continue;
            this.fFrames.add(new VMStackFrame(this, frame));
        }
        if (!this.fUnderlyingFrames.isEmpty()) {
            this.fLastSuspendedFrame = this.fUnderlyingFrames.get(0);
        }
    }
}

