/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.ocl.examples.debug.vm.ConditionChecker;
import org.eclipse.ocl.examples.debug.vm.data.VMNewBreakpointData;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMEvaluationVisitor;
import org.eclipse.ocl.examples.pivot.Element;

public class VMBreakpoint {
    private final long fID;
    private final String fTargetURI;
    private final int fLineNumber;
    private final int fHitCount;
    private final Element fElement;
    private final boolean fIsTemporary;
    private final String fConditionBody;
    private int fCurrentHitCount;
    private boolean fConditionEnabled;
    private boolean fConditionSuspendOnTrue;
    private boolean fLastValue;
    private ConditionChecker fChecker;

    public VMBreakpoint(Element element, VMNewBreakpointData data, boolean isTemporary) {
        this.fID = data.ID;
        this.fTargetURI = data.targetURI;
        this.fElement = element;
        this.fLineNumber = data.line;
        this.fIsTemporary = isTemporary;
        this.fHitCount = data.hitCount;
        this.fCurrentHitCount = 0;
        this.fConditionBody = data.condition;
        this.fConditionEnabled = data.conditionEnabled;
        this.fConditionSuspendOnTrue = data.conditionSuspendOnTrue;
    }

    public String getUri() {
        return this.fTargetURI;
    }

    public long getID() {
        return this.fID;
    }

    public Element getElement() {
        return this.fElement;
    }

    public boolean isTemporary() {
        return this.fIsTemporary;
    }

    public int getLineNumber() {
        return this.fLineNumber;
    }

    public int getHitCount() {
        return this.fCurrentHitCount;
    }

    public boolean expired() {
        return this.fHitCount > 0 && this.fCurrentHitCount >= this.fHitCount;
    }

    public boolean hitAndCheckIfTriggered(IVMEvaluationVisitor<?> visitor) throws CoreException {
        if (this.expired()) {
            return false;
        }
        if (!(this.fConditionBody == null || this.fConditionEnabled && this.checkCondition(visitor))) {
            return false;
        }
        if (this.fHitCount > 0) {
            return ++this.fCurrentHitCount == this.fHitCount;
        }
        return true;
    }

    private boolean checkCondition(IVMEvaluationVisitor<?> visitor) throws CoreException {
        if (this.fChecker == null) {
            this.fChecker = new ConditionChecker(this.fConditionBody, this.fElement);
        }
        boolean prevValue = this.fLastValue;
        this.fLastValue = this.fChecker.checkCondition(visitor);
        if (this.fConditionSuspendOnTrue) {
            return this.fLastValue;
        }
        return this.fLastValue == prevValue;
    }

    public String toString() {
        return "VM Breakpoint:" + this.fLineNumber + ", isTemp:" + this.fIsTemporary;
    }
}

