/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.vm.utils.ASTBindingHelper;
import org.eclipse.ocl.examples.debug.vm.utils.CompiledUnit;
import org.eclipse.ocl.examples.debug.vm.utils.IModuleSourceInfo;
import org.eclipse.ocl.examples.debug.vm.utils.LineNumberProvider;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;

public class UnitManager {
    private static final Logger logger = Logger.getLogger(UnitManager.class);
    @NonNull
    protected final MetaModelManager metaModelManager;
    @NonNull
    private final CompiledUnit fMainUnit;
    private Map<URI, UnitEntry> fUri2UnitMap;

    public static void collectAllImports(CompiledUnit mainUnit, HashSet<CompiledUnit> allUnits) {
    }

    UnitManager(@NonNull MetaModelManager metaModelManager, @NonNull CompiledUnit mainUnit) {
        this.metaModelManager = metaModelManager;
        this.fMainUnit = mainUnit;
        try {
            this.fUri2UnitMap = this.createURI2UnitMap(mainUnit);
        }
        catch (IOException e) {
            this.fUri2UnitMap = Collections.emptyMap();
            logger.error((Object)e);
        }
    }

    @NonNull
    public CompiledUnit getMainUnit() {
        return this.fMainUnit;
    }

    @Nullable
    public CompiledUnit getCompiledModule(@NonNull URI unitURI) {
        UnitEntry numberProvider = this.fUri2UnitMap.get(unitURI);
        if (numberProvider != null) {
            return numberProvider.getCompiledModule();
        }
        return null;
    }

    @Nullable
    public LineNumberProvider getLineNumberProvider(@NonNull URI unitURI) {
        return this.fUri2UnitMap.get(unitURI);
    }

    @Nullable
    public CompiledUnit findUnitForModule(@NonNull NamedElement module) {
        return this.findCompiledModuleRec(this.fMainUnit, module);
    }

    @Nullable
    private CompiledUnit findCompiledModuleRec(@NonNull CompiledUnit rootModule, @NonNull NamedElement module) {
        if (rootModule.getModules().contains(module)) {
            return rootModule;
        }
        for (CompiledUnit impModule : rootModule.getCompiledImports()) {
            CompiledUnit findModule;
            if (impModule == null || (findModule = this.findCompiledModuleRec(impModule, module)) == null) continue;
            return findModule;
        }
        return null;
    }

    @NonNull
    private Map<URI, UnitEntry> createURI2UnitMap(@NonNull CompiledUnit mainUnit) throws IOException {
        HashSet<CompiledUnit> allUnits = new HashSet<CompiledUnit>();
        allUnits.add(mainUnit);
        UnitManager.collectAllImports(mainUnit, allUnits);
        HashMap<URI, UnitEntry> file2Unit = new HashMap<URI, UnitEntry>();
        for (CompiledUnit nextUnit : allUnits) {
            if (nextUnit == null) continue;
            for (NamedElement module : nextUnit.getModules()) {
                IModuleSourceInfo sourceBinding;
                if (module == null || (sourceBinding = ASTBindingHelper.getModuleSourceBinding((Element)module)) == null) continue;
                UnitEntry entry = new UnitEntry(nextUnit, sourceBinding.getLineNumberProvider());
                file2Unit.put(nextUnit.getURI(), entry);
            }
        }
        return file2Unit;
    }

    private static class UnitEntry
    implements LineNumberProvider {
        @NonNull
        private final CompiledUnit fModule;
        @NonNull
        private final LineNumberProvider fProvider;

        public UnitEntry(@NonNull CompiledUnit unit, @NonNull LineNumberProvider lineNumberProvider) {
            this.fModule = unit;
            this.fProvider = lineNumberProvider;
        }

        @NonNull
        public CompiledUnit getCompiledModule() {
            return this.fModule;
        }

        @Override
        public int getLineEnd(int lineNumber) {
            return this.fProvider.getLineEnd(lineNumber);
        }

        @Override
        public int getLineCount() {
            return this.fProvider.getLineCount();
        }

        @Override
        public int getLineNumber(int offset) {
            return this.fProvider.getLineNumber(offset);
        }
    }
}

